
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
carbs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbs")
iron = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="iron")
vit_b6 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vit_b6")

# Set objective function
m.setObjective(4.69 * carbs**2 + 9.23 * carbs * vit_b6 + 3.95 * iron * vit_b6 + 9.48 * vit_b6**2 + 2.28 * carbs + 8.93 * iron + 8.42 * vit_b6, gp.GRB.MINIMIZE)

# Add constraints based on resource attributes
m.addConstr(14 * carbs + 17 * iron + 6 * vit_b6 <= 74, "immune_support_index")
m.addConstr(3 * carbs + 14 * iron + 1 * vit_b6 <= 189, "muscle_growth_index")
m.addConstr(9 * carbs + 3 * iron + 6 * vit_b6 <= 177, "digestive_support_index")


# Add additional constraints
m.addConstr(14 * carbs + 17 * iron >= 10, "immune_support_min1")
m.addConstr(14 * carbs**2 + 6 * vit_b6**2 >= 23, "immune_support_min2")
m.addConstr(14 * carbs + 17 * iron + 6 * vit_b6 >= 23, "immune_support_min3")

m.addConstr(14 * iron + 1 * vit_b6 >= 35, "muscle_growth_min1")
m.addConstr(3 * carbs + 14 * iron >= 43, "muscle_growth_min2")
m.addConstr(3 * carbs + 14 * iron + 1 * vit_b6 >= 43, "muscle_growth_min3")

m.addConstr(3 * iron + 6 * vit_b6 >= 31, "digestive_support_min1")
m.addConstr(9 * carbs**2 + 6 * vit_b6**2 >= 42, "digestive_support_min2")
m.addConstr(9 * carbs + 3 * iron + 6 * vit_b6 >= 42, "digestive_support_min3")

m.addConstr(6 * carbs**2 - 9 * iron**2 >= 0, "constraint1")
m.addConstr(2 * carbs**2 - 10 * vit_b6**2 >= 0, "constraint2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('carbs:', carbs.x)
    print('iron:', iron.x)
    print('vit_b6:', vit_b6.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

