
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="carbohydrates")  # grams of carbohydrates
x1 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, vtype="I", name="iron")  # milligrams of iron
x2 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="vitamin_B6")  # milligrams of vitamin B6

# Objective function
m.setObjective(4.69*x0**2 + 9.23*x0*x2 + 3.95*x1*x2 + 9.48*x2**2 + 2.28*x0 + 8.93*x1 + 8.42*x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(14*x0 <= 74)
m.addConstr(3*x0 <= 189)
m.addConstr(9*x0 <= 177)
m.addConstr(17*x1 <= 74)
m.addConstr(14*x1 <= 189)
m.addConstr(3*x1 <= 177)
m.addConstr(6*x2 <= 74)
m.addConstr(x2 <= 189)
m.addConstr(6*x2 <= 177)
m.addConstr(14*x0 + 17*x1 >= 10)
m.addConstr(14**2*x0 + 6**2*x2 >= 23)
m.addConstr(14*x0 + 17*x1 + 6*x2 >= 23)
m.addConstr(14*x1 + x2 >= 35)
m.addConstr(3*x0 + 14*x1 >= 43)
m.addConstr(3*x0 + 14*x1 + x2 >= 43)
m.addConstr(3*x1 + 6*x2 >= 31)
m.addConstr(9*x0 + 6**2*x2 >= 42)
m.addConstr(9*x0 + 3*x1 + 6*x2 >= 42)
m.addConstr(6*x0**2 - 9*x1**2 >= 0)
m.addConstr(2*x0**2 - 10*x2**2 >= 0)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carbohydrates: {x0.varValue}")
    print(f"Iron: {x1.varValue}")
    print(f"Vitamin B6: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
