
from gurobipy import *

# Create a model
m = Model("Optimization_Model")

# Decision Variables
pen_testers = m.addVar(vtype=GRB.INTEGER, name="pen_testers")
soc_operators = m.addVar(vtype=GRB.INTEGER, name="soc_operators")
network_administrators = m.addVar(vtype=GRB.INTEGER, name="network_administrators")
deployed_decoys = m.addVar(vtype=GRB.INTEGER, name="deployed_decoys")

# Objective Function
m.setObjective(1*pen_testers + 9*soc_operators + 3*network_administrators + 5*deployed_decoys, GRB.MINIMIZE)

# Constraints
# Power consumption constraints
m.addConstr(9.24*pen_testers + 10.88*soc_operators + 12.55*network_administrators + 4.75*deployed_decoys <= 131, "power_consumption_total")
m.addConstr(9.24*pen_testers + 4.75*deployed_decoys >= 24, "power_consumption_pen_decoy")
m.addConstr(12.55*network_administrators + 4.75*deployed_decoys >= 15, "power_consumption_net_decoy")
m.addConstr(9.24*pen_testers + 10.88*soc_operators >= 11, "power_consumption_pen_soc")
m.addConstr(9.24*pen_testers + 10.88*soc_operators + 12.55*network_administrators + 4.75*deployed_decoys >= 11, "power_consumption_all")

# Additional constraints
m.addConstr(6*pen_testers - 10*deployed_decoys >= 0, "pen_decoy_relationship")
m.addConstr(9.24*pen_testers + 12.55*network_administrators <= 123, "power_consumption_pen_net")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pen Testers: {pen_testers.x}")
    print(f"SOC Operators: {soc_operators.x}")
    print(f"Network Administrators: {network_administrators.x}")
    print(f"Deployed Decoys: {deployed_decoys.x}")
else:
    print("No optimal solution found.")
