
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
SOC_operators = m.addVar(vtype=gp.GRB.INTEGER, name="SOC_operators")
network_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="network_administrators")
deployed_decoys = m.addVar(vtype=gp.GRB.INTEGER, name="deployed_decoys")

# Objective function: Minimize 1*x0 + 9*x1 + 3*x2 + 5*x3
m.setObjective(pen_testers + 9*SOC_operators + 3*network_administrators + 5*deployed_decoys, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(9.24*pen_testers + 10.88*SOC_operators + 12.55*network_administrators + 4.75*deployed_decoys <= 131, "power_consumption_total")
m.addConstr(9.24*pen_testers + 4.75*deployed_decoys >= 24, "power_consumption_pen_testers_decoys")
m.addConstr(12.55*network_administrators + 4.75*deployed_decoys >= 15, "power_consumption_admins_decoys")
m.addConstr(9.24*pen_testers + 10.88*SOC_operators >= 11, "power_consumption_pen_testers_SOC")
m.addConstr(9.24*pen_testers + 10.88*SOC_operators + 12.55*network_administrators + 4.75*deployed_decoys >= 11, "power_consumption_all")
m.addConstr(6*pen_testers - 10*deployed_decoys >= 0, "pen_testers_decoys_tradeoff")
m.addConstr(9.24*pen_testers <= 123, "pen_testers_power_limit")
m.addConstr(12.55*network_administrators <= 123, "network_administrators_power_limit")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("pen testers: ", pen_testers.varValue)
    print("SOC operators: ", SOC_operators.varValue)
    print("network administrators: ", network_administrators.varValue)
    print("deployed decoys: ", deployed_decoys.varValue)
else:
    print("The model is infeasible")
