
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
vitamin_b6 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b6")
vitamin_b1 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b1")
fiber = model.addVar(vtype=GRB.INTEGER, name="fiber")
fat = model.addVar(vtype=GRB.INTEGER, name="fat")
vitamin_b4 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b4")
magnesium = model.addVar(vtype=GRB.CONTINUOUS, name="magnesium")
vitamin_b9 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b9")
zinc = model.addVar(vtype=GRB.CONTINUOUS, name="zinc")
vitamin_b7 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b7")


# Set objective function
model.setObjective(3 * vitamin_b6 + 1 * vitamin_b1 + 3 * fiber + 5 * fat + 4 * vitamin_b4 + 6 * magnesium + 4 * vitamin_b9 + 4 * zinc + 3 * vitamin_b7, GRB.MINIMIZE)

# Add constraints
model.addConstr(8.37 * vitamin_b6 + 9.95 * zinc >= 64)
model.addConstr(9.4 * vitamin_b4 + 12.6 * magnesium >= 59)
model.addConstr(2.08 * fat + 13.7 * vitamin_b7 >= 59)
model.addConstr(6.65 * vitamin_b1 + 9.4 * vitamin_b4 >= 28)
model.addConstr(12.86 * fiber + 4.14 * vitamin_b9 >= 46)
model.addConstr(8.37 * vitamin_b6 + 4.14 * vitamin_b9 >= 68)
model.addConstr(6.65 * vitamin_b1 + 13.7 * vitamin_b7 >= 65)
model.addConstr(6.65 * vitamin_b1 + 12.6 * magnesium >= 72)
model.addConstr(2.08 * fat + 9.4 * vitamin_b4 >= 38)
model.addConstr(6.65 * vitamin_b1 + 2.08 * fat >= 53)
model.addConstr(4.14 * vitamin_b9 + 13.7 * vitamin_b7 >= 72)
model.addConstr(2.08 * fat + 4.14 * vitamin_b9 >= 31)
model.addConstr(12.86 * fiber + 9.4 * vitamin_b4 >= 61)
model.addConstr(8.37 * vitamin_b6 + 13.7 * vitamin_b7 >= 73)
model.addConstr(12.86 * fiber + 2.08 * fat >= 57)
model.addConstr(12.86 * fiber + 13.7 * vitamin_b7 >= 66)
model.addConstr(6.65 * vitamin_b1 + 9.95 * zinc >= 43)
model.addConstr(2.08 * fat + 12.6 * magnesium >= 65)
model.addConstr(8.37 * vitamin_b6 + 9.4 * vitamin_b4 >= 75)

model.addConstr(8.37 * vitamin_b6 + 6.65 * vitamin_b1 + 12.86 * fiber + 2.08 * fat + 9.4 * vitamin_b4 + 12.6 * magnesium + 4.14 * vitamin_b9 + 9.95 * zinc + 13.7 * vitamin_b7 >= 75)
model.addConstr(10 * vitamin_b4 - 4 * zinc >= 0)
model.addConstr(7 * vitamin_b6 - 9 * magnesium >= 0)

model.addConstr(6.65 * vitamin_b1 + 9.95 * zinc <= 337)
model.addConstr(9.4 * vitamin_b4 + 4.14 * vitamin_b9 <= 678)
model.addConstr(12.86 * fiber + 9.4 * vitamin_b4 <= 319)
model.addConstr(12.6 * magnesium + 9.95 * zinc <= 305)
model.addConstr(12.6 * magnesium + 13.7 * vitamin_b7 <= 267)
model.addConstr(4.14 * vitamin_b9 + 9.95 * zinc <= 311)
model.addConstr(2.08 * fat + 9.95 * zinc <= 522)
model.addConstr(6.65 * vitamin_b1 + 13.7 * vitamin_b7 <= 583)
model.addConstr(12.86 * fiber + 4.14 * vitamin_b9 + 13.7 * vitamin_b7 <= 259)
model.addConstr(8.37 * vitamin_b6 + 9.4 * vitamin_b4 + 9.95 * zinc <= 277)
model.addConstr(8.37 * vitamin_b6 + 6.65 * vitamin_b1 + 12.6 * magnesium <= 443)
model.addConstr(12.86 * fiber + 12.6 * magnesium + 4.14 * vitamin_b9 <= 247)
model.addConstr(2.08 * fat + 9.4 * vitamin_b4 + 4.14 * vitamin_b9 <= 318)
model.addConstr(12.86 * fiber + 9.4 * vitamin_b4 + 12.6 * magnesium <= 472)
model.addConstr(8.37 * vitamin_b6 + 12.86 * fiber + 9.4 * vitamin_b4 <= 519)
model.addConstr(6.65 * vitamin_b1 + 9.4 * vitamin_b4 + 12.6 * magnesium <= 350)
model.addConstr(12.86 * fiber + 12.6 * magnesium + 13.7 * vitamin_b7 <= 95)
model.addConstr(2.08 * fat + 9.95 * zinc + 13.7 * vitamin_b7 <= 384)
model.addConstr(8.37 * vitamin_b6 + 6.65 * vitamin_b1 + 9.95 * zinc <= 665)
model.addConstr(6.65 * vitamin_b1 + 2.08 * fat + 13.7 * vitamin_b7 <= 438)
model.addConstr(6.65 * vitamin_b1 + 12.6 * magnesium + 4.14 * vitamin_b9 <= 656)
model.addConstr(2.08 * fat + 12.6 * magnesium + 9.95 * zinc <= 402)
model.addConstr(6.65 * vitamin_b1 + 12.6 * magnesium + 13.7 * vitamin_b7 <= 594)
model.addConstr(12.6 * magnesium + 9.95 * zinc + 13.7 * vitamin_b7 <= 532)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

