
from gurobipy import Model, GRB

# Create a new model
model = Model("Work_Hours_Optimization")

# Create variables
john_hours = model.addVar(lb=0, name="john_hours")
paul_hours = model.addVar(lb=0, name="paul_hours")
bobby_hours = model.addVar(lb=0, name="bobby_hours")
dale_hours = model.addVar(lb=0, name="dale_hours")

# Set objective function
model.setObjective(4*john_hours**2 + 7*john_hours*paul_hours + 4*john_hours*bobby_hours + 3*john_hours*dale_hours + 6*paul_hours*dale_hours + bobby_hours*dale_hours + 5*dale_hours**2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*john_hours + 3*bobby_hours >= 8, "c1")
model.addConstr(3*john_hours + 4*paul_hours + 3*bobby_hours >= 12, "c2")
model.addConstr(-10*john_hours + 9*bobby_hours >= 0, "c3")
model.addConstr(paul_hours**2 + 8*dale_hours**2 <= 76, "c4") # Using organization score for Paul and Dale
model.addConstr(6*bobby_hours**2 + 8*dale_hours**2 <= 64, "c5") # Using organization score for Bobby and Dale
model.addConstr(8*john_hours**2 + 6*bobby_hours**2 <= 103, "c6") # Using organization score for John and Bobby
model.addConstr(8*john_hours**2 + 8*dale_hours**2 <= 121, "c7") # Using organization score for John and Dale
model.addConstr(paul_hours + 6*bobby_hours <= 88, "c8") # Using organization score for Paul and Bobby
model.addConstr(8*john_hours + paul_hours + 6*bobby_hours + 8*dale_hours <= 88, "c9") # Using organization score for all
model.addConstr(3*john_hours + 4*paul_hours <= 79, "c10")
model.addConstr(3*bobby_hours + 5*dale_hours <= 39, "c11")
model.addConstr(3*john_hours**2 + 3*bobby_hours**2 <= 27, "c12")
model.addConstr(3*john_hours**2 + 5*dale_hours**2 <= 27, "c13")
model.addConstr(3*john_hours**2 + 3*bobby_hours**2 + 5*dale_hours**2 <= 72, "c14")
model.addConstr(3*john_hours + 4*paul_hours + 5*dale_hours <= 20, "c15")
model.addConstr(4*paul_hours**2 + 3*bobby_hours**2 + 5*dale_hours**2 <= 73, "c16")
model.addConstr(3*john_hours + 4*paul_hours + 3*bobby_hours + 5*dale_hours <= 73, "c17")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
