
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_John", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="hours_worked_by_Paul", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="hours_worked_by_Bobby", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="hours_worked_by_Dale", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Objective function
m.setObjective(4*x0**2 + 7*x0*x1 + 4*x0*x2 + 3*x0*x3 + 6*x1*x3 + x2*x3 + 5*x3**2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 == 8, name="John_organization_score")
m.addConstr(3*x0 == 3, name="John_computer_competence_rating")
m.addConstr(x1 == 1, name="Paul_organization_score")
m.addConstr(4*x1 == 4, name="Paul_computer_competence_rating")
m.addConstr(6*x2 == 6, name="Bobby_organization_score")
m.addConstr(3*x2 == 3, name="Bobby_computer_competence_rating")
m.addConstr(8*x3 == 8, name="Dale_organization_score")
m.addConstr(5*x3 == 5, name="Dale_computer_competence_rating")

m.addConstr(3*x0 + 3*x2 >= 8, name="combined_computer_rating_1")
m.addConstr(3*x0 + 4*x1 + 3*x2 >= 12, name="combined_computer_rating_2")
m.addConstr(-10*x0 + 9*x2 >= 0, name="john_bobby_hours")

m.addConstr(x1**2 + x3**2 <= 76, name="paul_dale_organization")
m.addConstr(x2**2 + x3**2 <= 64, name="bobby_dale_organization")
m.addConstr(8*x0**2 + 6*x2**2 <= 103, name="john_bobby_organization")
m.addConstr(8*x0**2 + 8*x3**2 <= 121, name="john_dale_organization")
m.addConstr(x1 + 6*x2 <= 88, name="paul_bobby_organization")
m.addConstr(8*x0 + x1 + 6*x2 + 8*x3 <= 88, name="total_organization")

m.addConstr(3*x0 + 4*x1 <= 79, name="john_paul_computer")
m.addConstr(3*x2 + 5*x3 <= 39, name="bobby_dale_computer")

m.addConstr(9*x0**2 + 9*x2**2 <= 27, name="john_bobby_computer_squared")
m.addConstr(9*x0**2 + 25*x3**2 <= 27, name="john_dale_computer_squared")
m.addConstr(9*x0**2 + 9*x2**2 + 25*x3**2 <= 72, name="total_computer_squared")

m.addConstr(3*x0 + 4*x1 + 5*x3 <= 20, name="john_paul_dale_computer")

m.addConstr(16*x1**2 + 9*x2**2 + 25*x3**2 <= 73, name="paul_bobby_dale_computer_squared")
m.addConstr(3*x0 + 4*x1 + 3*x2 + 5*x3 <= 73, name="total_computer")

# Correct the initial constraints for organization and computer competence ratings
m.addConstr(x0 == 8, name="john_org")
m.addConstr(3*x0 == 3, name="john_comp")
m.addConstr(x1 == 1, name="paul_org")
m.addConstr(4*x1 == 4, name="paul_comp")
m.addConstr(6*x2 == 6, name="bobby_org")
m.addConstr(3*x2 == 3, name="bobby_comp")
m.addConstr(8*x3 == 8, name="dale_org")
m.addConstr(5*x3 == 5, name="dale_comp")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by John: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Bobby: ", x2.varValue)
    print("Hours worked by Dale: ", x3.varValue)
else:
    print("The model is infeasible")
