
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
hank = m.addVar(lb=0, name="hank", vtype=gp.GRB.CONTINUOUS)
laura = m.addVar(lb=0, name="laura", vtype=gp.GRB.INTEGER)
jean = m.addVar(lb=0, name="jean", vtype=gp.GRB.CONTINUOUS)
bill = m.addVar(lb=0, name="bill", vtype=gp.GRB.CONTINUOUS)
peggy = m.addVar(lb=0, name="peggy", vtype=gp.GRB.CONTINUOUS)

# Set objective
m.setObjective(1.69*hank**2 + 7.69*hank*jean + 3.28*hank*peggy + 7.18*laura**2 + 1.46*laura*bill + 6.67*laura*peggy + 2.3*jean**2 + 7.74*jean*bill + 4.9*jean*peggy + 4.03*bill**2 + 3.43*bill*peggy + 6.68*peggy**2 + 8.59*hank + 6.21*laura + 3.9*jean, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*hank + 1*bill >= 10)
m.addConstr(1*laura + 1*jean >= 21)
m.addConstr(17*hank**2 + 23*peggy**2 >= 15)
m.addConstr(17*hank**2 + 1*laura**2 >= 9)
m.addConstr(1*laura + 1*bill >= 9)
m.addConstr(1*laura**2 + 1*jean**2 + 1*bill**2 >= 22)
m.addConstr(4*hank**2 + 14*bill**2 >= 45)
m.addConstr(4*hank + 17*laura + 5*peggy >= 30)
m.addConstr(4*hank**2 + 17*laura**2 + 14*bill**2 >= 30)
m.addConstr(17*laura + 14*bill + 5*peggy >= 30)
m.addConstr(4*hank**2 + 16*jean**2 + 14*bill**2 >= 30)
m.addConstr(4*hank + 17*laura + 5*peggy >= 35)
m.addConstr(4*hank + 17*laura + 14*bill >= 35)
m.addConstr(17*laura + 14*bill + 5*peggy >= 35)
m.addConstr(4*hank + 16*jean + 14*bill >= 35)
m.addConstr(4*hank**2 + 17*laura**2 + 5*peggy**2 >= 33)
m.addConstr(4*hank**2 + 17*laura**2 + 14*bill**2 >= 33)
m.addConstr(17*laura**2 + 14*bill**2 + 5*peggy**2 >= 33)
m.addConstr(4*hank + 16*jean + 14*bill >= 33)
m.addConstr(4*hank + 17*laura + 5*peggy >= 43)
m.addConstr(4*hank + 17*laura + 14*bill >= 43)
m.addConstr(17*laura + 14*bill + 5*peggy >= 43)
m.addConstr(4*hank + 16*jean + 14*bill >= 43)
m.addConstr(1*laura + 23*peggy <= 114)
m.addConstr(17*hank**2 + 1*laura**2 <= 69)
m.addConstr(1*jean + 23*peggy <= 30)
m.addConstr(17*hank + 1*bill <= 100)
m.addConstr(17*hank**2 + 23*peggy**2 <= 123)
m.addConstr(17*hank**2 + 1*bill**2 + 23*peggy**2 <= 122)
m.addConstr(1*laura + 1*jean + 23*peggy <= 44)
m.addConstr(17*hank + 1*laura + 1*jean + 1*bill + 23*peggy <= 44)
m.addConstr(4*hank + 16*jean <= 86)
m.addConstr(17*laura + 16*jean <= 240)
m.addConstr(16*jean**2 + 5*peggy**2 <= 169)
m.addConstr(4*hank + 17*laura <= 147)
m.addConstr(14*bill + 5*peggy <= 219)
m.addConstr(4*hank + 14*bill <= 79)
m.addConstr(16*jean**2 + 14*bill**2 <= 183)
m.addConstr(4*hank + 5*peggy <= 83)
m.addConstr(17*laura + 5*peggy <= 207)
m.addConstr(17*laura + 14*bill <= 112)
m.addConstr(17*laura + 14*bill + 5*peggy <= 243)
m.addConstr(4*hank + 17*laura + 14*bill <= 68)
m.addConstr(4*hank**2 + 16*jean**2 + 14*bill**2 <= 141)
m.addConstr(16*jean + 14*bill + 5*peggy <= 156)
m.addConstr(17*laura + 16*jean + 14*bill <= 219)
m.addConstr(4*hank + 17*laura + 16*jean + 14*bill + 5*peggy <= 219)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
