
from gurobipy import Model, GRB

# Create a new model
model = Model("Supplement_Optimization")

# Create variables
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")
calcium = model.addVar(lb=0, vtype=GRB.INTEGER, name="calcium")
vitamin_b4 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b4")

# Set objective function
model.setObjective(8.54 * zinc + 6.37 * calcium + 8.42 * vitamin_b4, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * calcium + 18 * vitamin_b4 >= 64, "c1")
model.addConstr(17 * zinc + 5 * calcium >= 58, "c2")
model.addConstr(17 * zinc + 5 * calcium + 18 * vitamin_b4 >= 58, "c3")
model.addConstr(27 * calcium + 1 * vitamin_b4 >= 37, "c4")
model.addConstr(23 * zinc + 27 * calcium >= 45, "c5")
model.addConstr(23 * zinc + 1 * vitamin_b4 >= 34, "c6")
model.addConstr(23 * zinc + 27 * calcium + 1 * vitamin_b4 >= 34, "c7")
model.addConstr(3 * zinc - 5 * calcium >= 0, "c8")
model.addConstr(4 * zinc - 4 * vitamin_b4 >= 0, "c9")
model.addConstr(17 * zinc + 18 * vitamin_b4 <= 149, "c10")
model.addConstr(17 * zinc + 5 * calcium + 18 * vitamin_b4 <= 249, "c11")


# Resource Constraints (Implicitly handled by other constraints, but included for clarity)
model.addConstr(17 * zinc + 5 * calcium + 18 * vitamin_b4 <= 282, "r0") # Cardiovascular support
model.addConstr(23 * zinc + 27 * calcium + 1 * vitamin_b4 <= 170, "r1") # Energy stability


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Zinc: %g' % zinc.x)
    print('Calcium: %g' % calcium.x)
    print('Vitamin B4: %g' % vitamin_b4.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)
