
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
z = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_zinc")
c = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_calcium")
v = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")

# Objective function
m.setObjective(8.54*z + 6.37*c + 8.42*v, GRB.MINIMIZE)

# Constraints
m.addConstr(5*c + 18*v >= 64, "cardiovascular_support_index_1")
m.addConstr(17*z + 5*c >= 58, "cardiovascular_support_index_2")
m.addConstr(17*z + 5*c + 18*v >= 58, "total_cardiovascular_support_index")

m.addConstr(27*c + 1*v >= 37, "energy_stability_index_1")
m.addConstr(23*z + 27*c >= 45, "energy_stability_index_2")
m.addConstr(23*z + 1*v >= 34, "energy_stability_index_3")
m.addConstr(23*z + 27*c + 1*v >= 34, "total_energy_stability_index")

m.addConstr(3*z - 5*c >= 0, "linear_constraint_1")
m.addConstr(4*z - 4*v >= 0, "linear_constraint_2")

m.addConstr(17*z + 18*v <= 149, "cardiovascular_support_upper_bound_1")
m.addConstr(17*z + 5*c + 18*v <= 249, "total_cardiovascular_support_upper_bound")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Zinc: {z.x}")
    print(f"Milligrams of Calcium: {c.x}")
    print(f"Milligrams of Vitamin B4: {v.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
