
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(lb=0, name="milligrams_of_zinc")  # No lower bound specified, assuming 0
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="milligrams_of_calcium")
x2 = m.addVar(lb=0, name="milligrams_of_vitamin_B4")

# Objective function
m.setObjective(8.54 * x0 + 6.37 * x1 + 8.42 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(17 * x0 + 5 * x1 + 18 * x2 <= 282, name="cardiovascular_support_index")
m.addConstr(23 * x0 + 27 * x1 + x2 <= 170, name="energy_stability_index")
m.addConstr(5 * x1 + 18 * x2 >= 64, name="cardiovascular_support_index_calcium_vitamin_B4")
m.addConstr(17 * x0 + 5 * x1 >= 58, name="cardiovascular_support_index_zinc_calcium")
m.addConstr(17 * x0 + 5 * x1 + 18 * x2 >= 58, name="cardiovascular_support_index_all")
m.addConstr(27 * x1 + x2 >= 37, name="energy_stability_index_calcium_vitamin_B4")
m.addConstr(23 * x0 + 27 * x1 >= 45, name="energy_stability_index_zinc_calcium")
m.addConstr(23 * x0 + x2 >= 34, name="energy_stability_index_zinc_vitamin_B4")
m.addConstr(23 * x0 + 27 * x1 + x2 >= 34, name="energy_stability_index_all")
m.addConstr(3 * x0 - 5 * x1 >= 0, name="zinc_calcium_constraint")
m.addConstr(4 * x0 - 4 * x2 >= 0, name="zinc_vitamin_B4_constraint")
m.addConstr(17 * x0 + 18 * x2 <= 149, name="cardiovascular_support_index_zinc_vitamin_B4")
m.addConstr(17 * x0 + 5 * x1 + 18 * x2 <= 249, name="cardiovascular_support_index_all_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of zinc: ", x0.varValue)
    print("Milligrams of calcium: ", x1.varValue)
    print("Milligrams of vitamin B4: ", x2.varValue)
else:
    print("The model is infeasible")
