
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")
b7 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b7")
fat = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fat")
b12 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b12")
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")

# Set objective function
model.setObjective(9 * b1 + 1 * b7 + 7 * fat + 8 * b12 + 1 * zinc, GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * fat + 24 * zinc >= 45, "c1")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 51, "c2")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 51, "c3")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 51, "c4")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 51, "c5")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 51, "c6")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 51, "c7")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 43, "c8")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 43, "c9")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 43, "c10")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 43, "c11")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 43, "c12")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 43, "c13")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 50, "c14")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 50, "c15")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 50, "c16")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 50, "c17")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 50, "c18")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 50, "c19")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 56, "c20")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 56, "c21")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 56, "c22")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 56, "c23")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 56, "c24")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 56, "c25")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 67, "c26")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 67, "c27")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 67, "c28")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 67, "c29")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 67, "c30")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 67, "c31")
model.addConstr(3 * b1 + 2 * b7 + 24 * zinc >= 49, "c32")
model.addConstr(25 * fat + 16 * b12 + 24 * zinc >= 49, "c33")
model.addConstr(3 * b1 + 16 * b12 + 24 * zinc >= 49, "c34")
model.addConstr(2 * b7 + 25 * fat + 16 * b12 >= 49, "c35")
model.addConstr(3 * b1 + 25 * fat + 24 * zinc >= 49, "c36")
model.addConstr(3 * b1 + 25 * fat + 16 * b12 >= 49, "c37")
model.addConstr(3 * b1 + 16 * b12 <= 328, "c38")
model.addConstr(2 * b7 + 16 * b12 <= 167, "c39")
model.addConstr(3 * b1 + 2 * b7 <= 328, "c40")
model.addConstr(2 * b7 + 25 * fat <= 341, "c41")
model.addConstr(3 * b1 + 25 * fat <= 342, "c42")
model.addConstr(3 * b1 + 2 * b7 + 25 * fat + 16 * b12 + 24 * zinc <= 342, "c43")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

