
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x1 = m.addVar(lb=-gp.inf, name="milligrams of vitamin B1")
x2 = m.addVar(lb=-gp.inf, name="milligrams of vitamin B7")
x3 = m.addVar(lb=-gp.inf, name="grams of fat")
x4 = m.addVar(lb=-gp.inf, name="milligrams of vitamin B12")
x5 = m.addVar(lb=-gp.inf, name="milligrams of zinc")

# Objective function
m.setObjective(9*x1 + x2 + 7*x3 + 8*x4 + x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x1 + 2*x2 + 25*x3 + 16*x4 + 24*x5 <= 353)
m.addConstr(3*x1 <= 3)
m.addConstr(2*x2 <= 2)
m.addConstr(25*x3 <= 25)
m.addConstr(16*x4 <= 16)
m.addConstr(24*x5 <= 24)
m.addConstr(25*x3 + 24*x5 >= 45)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 51)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 51)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 51)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 51)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 51)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 51)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 43)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 43)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 43)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 43)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 43)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 43)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 50)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 50)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 50)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 50)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 50)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 50)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 56)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 56)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 56)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 56)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 56)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 56)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 67)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 67)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 67)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 67)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 67)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 67)
m.addConstr(3*x1 + 2*x2 + 24*x5 >= 49)
m.addConstr(25*x3 + 16*x4 + 24*x5 >= 49)
m.addConstr(3*x1 + 16*x4 + 24*x5 >= 49)
m.addConstr(2*x2 + 25*x3 + 16*x4 >= 49)
m.addConstr(3*x1 + 25*x3 + 24*x5 >= 49)
m.addConstr(3*x1 + 25*x3 + 16*x4 >= 49)
m.addConstr(3*x1 + 16*x4 <= 328)
m.addConstr(2*x2 + 16*x4 <= 167)
m.addConstr(3*x1 + 2*x2 <= 328)
m.addConstr(2*x2 + 25*x3 <= 341)
m.addConstr(3*x1 + 25*x3 <= 342)
m.addConstr(3*x1 + 2*x2 + 25*x3 + 16*x4 + 24*x5 <= 342)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of vitamin B1: ", x1.varValue)
    print("Milligrams of vitamin B7: ", x2.varValue)
    print("Grams of fat: ", x3.varValue)
    print("Milligrams of vitamin B12: ", x4.varValue)
    print("Milligrams of zinc: ", x5.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
