
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cereal = m.addVar(name="bowls_of_cereal")
pickles = m.addVar(name="pickles")

# Set objective function
m.setObjective(1.79 * cereal + 4.7 * pickles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * cereal + 3 * pickles >= 37, "carbohydrates_min")
m.addConstr(6 * cereal + 2 * pickles >= 11, "sourness_min")
m.addConstr(10 * cereal - 6 * pickles >= 0, "cereal_pickles_ratio")
m.addConstr(3 * cereal + 3 * pickles <= 46, "carbohydrates_max") # Combined redundant constraints
m.addConstr(6 * cereal + 2 * pickles <= 39, "sourness_max") # Combined redundant constraints


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bowls_of_cereal:', cereal.x)
    print('pickles:', pickles.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

