
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model (non-integer quantities allowed)
x0 = m.addVar(name="bowls_of_cereal", lb=0, vtype=GRB.CONTINUOUS)
x1 = m.addVar(name="pickles", lb=0, vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(1.79*x0 + 4.7*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x0 + 3*x1 >= 37, name="min_carbohydrates")
m.addConstr(6*x0 + 2*x1 >= 11, name="min_sourness")
m.addConstr(10*x0 - 6*x1 >= 0, name="specific_linear_combination")
m.addConstr(3*x0 + 3*x1 <= 46, name="max_carbohydrates")
m.addConstr(6*x0 + 2*x1 <= 39, name="max_sourness")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"bowls_of_cereal: {x0.x}, pickles: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
