
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
bowls_of_cereal = m.addVar(name="bowls_of_cereal", lb=0)  # No lower bound specified, assuming 0
pickles = m.addVar(name="pickles", lb=0)  # No lower bound specified, assuming 0

# Objective function
m.setObjective(1.79 * bowls_of_cereal + 4.7 * pickles, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3 * bowls_of_cereal + 3 * pickles >= 37, name="min_carbohydrates")
m.addConstr(6 * bowls_of_cereal + 2 * pickles >= 11, name="min_sourness_index")
m.addConstr(10 * bowls_of_cereal - 6 * pickles >= 0, name="cereal_pickles_constraint")
m.addConstr(3 * bowls_of_cereal + 3 * pickles <= 46, name="max_carbohydrates")
m.addConstr(6 * bowls_of_cereal + 2 * pickles <= 39, name="max_sourness_index")

# Optimize
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Bowls of cereal: {bowls_of_cereal.varValue}")
    print(f"Pickles: {pickles.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
