
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create decision variables
steaks = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="steaks")
sashimi = model.addVar(lb=0, vtype=GRB.INTEGER, name="sashimi")

# Set objective function
model.setObjective(4.37 * steaks + 5.64 * sashimi, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * steaks + 6 * sashimi >= 35, "iron_min")
model.addConstr(4 * steaks + 10 * sashimi >= 45, "calcium_min")
model.addConstr(-3 * steaks + 6 * sashimi >= 0, "steak_sashimi_ratio")
model.addConstr(5 * steaks + 6 * sashimi <= 165, "iron_max")  # Adjusted upper bound to 165
model.addConstr(4 * steaks + 10 * sashimi <= 97, "calcium_max") # Adjusted upper bound to 97


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Steaks: {steaks.x}")
    print(f"  Sashimi: {sashimi.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

