
from gurobipy import *

# Create a model
m = Model("Nutrition_Optimization")

# Define variables
steaks = m.addVar(lb=0, name="steaks", vtype=GRB.CONTINUOUS)
sashimi = m.addVar(lb=0, name="sashimi", vtype=GRB.INTEGER)

# Objective function: Minimize 4.37 * steaks + 5.64 * sashimi
m.setObjective(4.37 * steaks + 5.64 * sashimi, GRB.MINIMIZE)

# Constraints
# Iron constraint: At least 35 mg from both
m.addConstr(5 * steaks + 6 * sashimi >= 35, name="iron_minimum")

# Calcium constraint: At least 45 mg from both
m.addConstr(4 * steaks + 10 * sashimi >= 45, name="calcium_minimum")

# Total iron limit: No more than 165 mg
m.addConstr(5 * steaks + 6 * sashimi <= 165, name="iron_maximum")

# Total calcium limit: No more than 97 mg
m.addConstr(4 * steaks + 10 * sashimi <= 97, name="calcium_maximum")

# Linear constraint: -3 * steaks + 6 * sashimi >= 0
m.addConstr(-3 * steaks + 6 * sashimi >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Steaks: {steaks.x}")
    print(f"Sashimi: {sashimi.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
