
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    steaks = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="steaks", vtype=gurobi.GRB.CONTINUOUS)
    sashimi = model.addVar(lb=0, name="sashimi", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 4.37 * steaks + 5.64 * sashimi
    model.setObjective(4.37 * steaks + 5.64 * sashimi, gurobi.GRB.MINIMIZE)

    # Constraints
    # 1. At least 35 mg of iron
    model.addConstr(5 * steaks + 6 * sashimi >= 35, name="iron_min")

    # 2. At least 45 mg of calcium
    model.addConstr(4 * steaks + 10 * sashimi >= 45, name="calcium_min")

    # 3. Linear constraint: -3 * steaks + 6 * sashimi >= 0
    model.addConstr(-3 * steaks + 6 * sashimi >= 0, name="linear_constraint")

    # 4. Upper bounds
    model.addConstr(5 * steaks + 6 * sashimi <= 169, name="iron_max")
    model.addConstr(4 * steaks + 10 * sashimi <= 149, name="calcium_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Steaks: {steaks.varValue}")
        print(f"Sashimi: {sashimi.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimization_problem()
