
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
dale_hours = m.addVar(vtype=gp.GRB.INTEGER, name="dale_hours")
paul_hours = m.addVar(vtype=gp.GRB.CONTINUOUS, name="paul_hours")

# Set objective function
m.setObjective(6 * dale_hours * paul_hours + 2 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * dale_hours + 17 * paul_hours >= 45, "productivity_lower_bound")
m.addConstr(3 * dale_hours + 17 * paul_hours <= 79, "productivity_upper_bound")
m.addConstr(12 * dale_hours + 6 * paul_hours >= 59, "organization_lower_bound")
m.addConstr(12 * dale_hours + 6 * paul_hours <= 146, "organization_upper_bound")
m.addConstr(-4 * dale_hours * dale_hours + 3 * paul_hours * paul_hours >= 0, "quadratic_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Dale's hours: {dale_hours.x}")
    print(f"  Paul's hours: {paul_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

