
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Dale")  # Integer constraint for Dale
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")  # Continuous variable for Paul

# Define the objective function
m.setObjective(6*x0*x1 + 2*x1, GRB.MINIMIZE)

# Constraints
# Total combined productivity rating from hours worked must be at least 45
m.addConstr(3*x0 + 17*x1 >= 45, name="productivity_rating_min")

# Total combined organization score from the square of hours worked by Dale and hours worked by Paul should be at least 59
m.addConstr(12*(x0**2) + 6*(x1**2) >= 59, name="organization_score_squared_min")

# Another constraint on total combined organization score (linear)
m.addConstr(12*x0 + 6*x1 >= 59, name="organization_score_min")

# Quadratic constraint involving hours worked by both individuals must be non-negative
m.addConstr(-4*(x0**2) + 3*(x1**2) >= 0, name="quadratic_constraint")

# Maximum total combined productivity rating is 79
m.addConstr(3*x0 + 17*x1 <= 79, name="productivity_rating_max")

# Maximum total combined organization score is 146
m.addConstr(12*x0 + 6*x1 <= 146, name="organization_score_max")

# Solve the model
m.optimize()

# Print solution if found
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x0 = {x0.x}, x1 = {x1.x}")
else:
    print("No optimal solution found")
