
import gurobi

def solve_optimization_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    D = m.addVar(name="Dale_hours", vtype=gurobi.GRB.INTEGER, lb=0)  # Integer for Dale
    P = m.addVar(name="Paul_hours", vtype=gurobi.GRB.CONTINUOUS, lb=0)  # Continuous for Paul

    # Objective function
    m.setObjective(6 * D * P + 2 * P, gurobi.GRB.MINIMIZE)

    # Constraints
    m.addConstr(3 * D + 17 * P >= 45, name="productivity_rating_min")
    m.addConstr(12 * D**2 + 6 * P**2 >= 59, name="organization_score_min_quad")
    m.addConstr(12 * D + 6 * P >= 59, name="organization_score_min_lin")
    m.addConstr(-4 * D**2 + 3 * P**2 >= 0, name="quadratic_constraint")
    m.addConstr(3 * D + 17 * P <= 79, name="productivity_rating_max")
    m.addConstr(12 * D + 6 * P <= 152, name="organization_score_max")

    # Solve the model
    m.optimize()

    # Print the status and solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Dale's hours: {D.varValue}")
        print(f"Paul's hours: {P.varValue}")
        print(f"Objective: {m.objVal}")
    elif m.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
