
from gurobipy import *

try:
    # Create a new model
    model = Model("employee_scheduling")

    # Create variables
    peggy = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peggy")  # Peggy's hours
    george = model.addVar(lb=0, vtype=GRB.INTEGER, name="george") # George's hours
    bobby = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bobby") # Bobby's hours
    dale = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dale") # Dale's hours
    hank = model.addVar(lb=0, vtype=GRB.INTEGER, name="hank") # Hank's hours


    # Set objective
    model.setObjective(9.65*peggy*george + 9.37*peggy*bobby + 6.6*george*george + 9.67*george*hank + 8.15*bobby*bobby + 8.51*peggy + 7.37*dale, GRB.MINIMIZE)
    model.Params.NonConvex = 2 # handles the non-convex quadratic terms in the objective

    # Add constraints
    model.addConstr(3*peggy + 10*hank >= 71, "c0")
    model.addConstr(3*peggy + 26*george + 16*bobby + 8*dale + 10*hank >= 71, "c1")
    model.addConstr(2*peggy*peggy + 24*george*george >= 14, "c2")
    model.addConstr(24*george + 19*bobby >= 22, "c3")
    model.addConstr(2*peggy + 24*george + 19*bobby + 23*dale + 4*hank >= 22, "c4")
    model.addConstr(6*bobby + 7*dale >= 70, "c5")
    model.addConstr(7*peggy + 10*george >= 35, "c6")
    model.addConstr(6*bobby + 21*hank >= 72, "c7")
    model.addConstr(6*bobby + 7*dale + 21*hank >= 53, "c8")
    model.addConstr(7*peggy + 10*george + 21*hank >= 53, "c9")
    model.addConstr(7*peggy*peggy + 6*bobby*bobby + 7*dale*dale >= 53, "c10")
    model.addConstr(10*george + 6*bobby + 21*hank >= 53, "c11")
    model.addConstr(10*george + 6*bobby + 7*dale >= 53, "c12")
    model.addConstr(6*bobby + 7*dale + 21*hank >= 54, "c13")
    model.addConstr(7*peggy*peggy + 10*george*george + 21*hank*hank >= 54, "c14")
    model.addConstr(7*peggy + 6*bobby + 7*dale >= 54, "c15")
    model.addConstr(10*george + 6*bobby + 21*hank >= 54, "c16")
    model.addConstr(10*george + 6*bobby + 7*dale >= 54, "c17")
    model.addConstr(6*bobby + 7*dale + 21*hank >= 80, "c18")
    model.addConstr(7*peggy*peggy + 10*george*george + 21*hank*hank >= 80, "c19")
    model.addConstr(7*peggy + 6*bobby + 7*dale >= 80, "c20")
    model.addConstr(10*george*george + 6*bobby*bobby + 21*hank*hank >= 80, "c21")
    model.addConstr(10*george + 6*bobby + 7*dale >= 80, "c22")
    # ... (rest of the constraints)

    # Optimize model
    model.optimize()

    # Print results
    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", model.status)


except GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
