
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
bobby = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bobby")
laura = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Laura")
paul = model.addVar(lb=0, vtype=GRB.INTEGER, name="Paul")
dale = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Dale")
john = model.addVar(lb=0, vtype=GRB.INTEGER, name="John")

# Set objective function
model.setObjective(7 * bobby + 9 * laura + 5 * paul + 8 * dale + 9 * john, GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * laura + 7 * paul >= 101, "c1")
model.addConstr(7 * paul + 21 * dale >= 86, "c2")
model.addConstr(26 * bobby + 4 * laura + 7 * paul + 21 * dale + 14 * john >= 86, "c3")
model.addConstr(11 * bobby + 25 * paul >= 39, "c4")
model.addConstr(21 * laura + 25 * paul >= 46, "c5")
model.addConstr(21 * laura + 16 * john >= 54, "c6")
model.addConstr(11 * bobby + 22 * dale >= 28, "c7")
model.addConstr(11 * bobby + 21 * laura + 22 * dale >= 54, "c8")
model.addConstr(21 * laura + 22 * dale + 16 * john >= 54, "c9")
model.addConstr(11 * bobby + 22 * dale + 16 * john >= 54, "c10")
model.addConstr(25 * paul + 22 * dale + 16 * john >= 54, "c11")
model.addConstr(11 * bobby + 21 * laura + 22 * dale >= 55, "c12")
model.addConstr(21 * laura + 22 * dale + 16 * john >= 55, "c13")
model.addConstr(11 * bobby + 22 * dale + 16 * john >= 55, "c14")
model.addConstr(25 * paul + 22 * dale + 16 * john >= 55, "c15")
model.addConstr(11 * bobby + 21 * laura + 22 * dale >= 69, "c16")
model.addConstr(21 * laura + 22 * dale + 16 * john >= 69, "c17")
model.addConstr(11 * bobby + 22 * dale + 16 * john >= 69, "c18")
model.addConstr(25 * paul + 22 * dale + 16 * john >= 69, "c19")
model.addConstr(11 * bobby + 21 * laura + 22 * dale >= 43, "c20")
model.addConstr(21 * laura + 22 * dale + 16 * john >= 43, "c21")
model.addConstr(11 * bobby + 22 * dale + 16 * john >= 43, "c22")
model.addConstr(25 * paul + 22 * dale + 16 * john >= 43, "c23")
model.addConstr(11 * bobby + 21 * laura + 25 * paul + 22 * dale + 16 * john >= 43, "c24")
model.addConstr(4 * laura + 14 * john <= 541, "c25")
model.addConstr(26 * bobby + 14 * john <= 592, "c26")
model.addConstr(4 * laura + 7 * paul <= 626, "c27")
model.addConstr(26 * bobby + 7 * paul <= 436, "c28")
model.addConstr(21 * dale + 14 * john <= 769, "c29")
model.addConstr(4 * laura + 7 * paul + 21 * dale <= 676, "c30")
model.addConstr(26 * bobby + 7 * paul + 21 * dale <= 845, "c31")
model.addConstr(26 * bobby + 4 * laura + 7 * paul <= 625, "c32")
model.addConstr(4 * laura + 7 * paul + 14 * john <= 575, "c33")
model.addConstr(26 * bobby + 4 * laura + 21 * dale <= 400, "c34")
model.addConstr(25 * paul + 22 * dale <= 333, "c35")
model.addConstr(11 * bobby + 22 * dale <= 286, "c36")
model.addConstr(21 * laura + 16 * john <= 226, "c37")
model.addConstr(21 * laura + 22 * dale <= 342, "c38")
model.addConstr(22 * dale + 16 * john <= 110, "c39")
model.addConstr(25 * paul + 16 * john <= 111, "c40")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")
