
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="hours_worked_by_Bobby", lb=0)
    x1 = model.addVar(name="hours_worked_by_Laura", lb=0)
    x2 = model.addVar(name="hours_worked_by_Paul", lb=0, integrality=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="hours_worked_by_Dale", lb=0)
    x4 = model.addVar(name="hours_worked_by_John", lb=0, integrality=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(7 * x0 + 9 * x1 + 5 * x2 + 8 * x3 + 9 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(26 * x0 <= 972)
    model.addConstr(11 * x0 <= 354)
    model.addConstr(4 * x1 <= 972)
    model.addConstr(21 * x1 <= 354)
    model.addConstr(7 * x2 <= 972)
    model.addConstr(25 * x2 <= 354)
    model.addConstr(21 * x3 <= 972)
    model.addConstr(22 * x3 <= 354)
    model.addConstr(14 * x4 <= 972)
    model.addConstr(16 * x4 <= 354)

    model.addConstr(4 * x1 + 7 * x2 >= 101)
    model.addConstr(7 * x2 + 21 * x3 >= 86)
    model.addConstr(26 * x0 + 4 * x1 + 7 * x2 + 21 * x3 + 14 * x4 >= 86)
    model.addConstr(11 * x0 + 25 * x2 >= 39)
    model.addConstr(21 * x1 + 25 * x2 >= 46)
    model.addConstr(21 * x1 + 16 * x4 >= 54)
    model.addConstr(11 * x0 + 22 * x3 >= 28)
    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 54)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 54)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 54)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 54)

    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 55)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 55)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 55)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 55)

    model.addConstr(11 * x0 + 4 * x1 + 22 * x3 >= 69)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 69)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 69)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 69)

    model.addConstr(11 * x0 + 21 * x1 + 22 * x3 >= 43)
    model.addConstr(21 * x1 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(11 * x0 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(25 * x2 + 22 * x3 + 16 * x4 >= 43)
    model.addConstr(11 * x0 + 21 * x1 + 25 * x2 + 22 * x3 + 16 * x4 >= 43)

    model.addConstr(4 * x1 + 14 * x4 <= 541)
    model.addConstr(26 * x0 + 14 * x4 <= 592)
    model.addConstr(4 * x1 + 7 * x2 <= 626)
    model.addConstr(26 * x0 + 7 * x2 <= 436)
    model.addConstr(21 * x3 + 14 * x4 <= 769)
    model.addConstr(4 * x1 + 7 * x2 + 21 * x3 <= 676)
    model.addConstr(26 * x0 + 7 * x2 + 21 * x3 <= 845)
    model.addConstr(26 * x0 + 4 * x1 + 7 * x2 <= 625)
    model.addConstr(4 * x1 + 7 * x2 + 16 * x4 <= 575)
    model.addConstr(26 * x0 + 4 * x1 + 21 * x3 <= 400)

    model.addConstr(25 * x2 + 22 * x3 <= 333)
    model.addConstr(11 * x0 + 22 * x3 <= 286)
    model.addConstr(21 * x1 + 16 * x4 <= 226)
    model.addConstr(21 * x1 + 22 * x3 <= 342)
    model.addConstr(22 * x3 + 16 * x4 <= 110)
    model.addConstr(25 * x2 + 16 * x4 <= 111)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Hours worked by Bobby: ", x0.varValue)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by Paul: ", x2.varValue)
        print("Hours worked by Dale: ", x3.varValue)
        print("Hours worked by John: ", x4.varValue)
    else:
        print("No solution found")

optimize_problem()
