
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables (assuming non-negative)
x0 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_D")
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_potassium")
x2 = model.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_K")

# Objective function
model.setObjective(8*x0 + 3*x1 + x2, GRB.MINIMIZE)

# Constraints based on the problem description
model.addConstr(x0 >= 0)
model.addConstr(x1 >= 0)
model.addConstr(x2 >= 0)

# Digestive support index constraints
model.addConstr(3*x0 + 3*x1 + 1*x2 >= 7, name="digestive_support_index_total")

# Cardiovascular support index constraints
model.addConstr(3*x0 + 5*x1 + 5*x2 >= 9, name="cardiovascular_support_index_total")
model.addConstr(3*x0 + 5*x2 >= 9, name="cardiovascular_support_vitamin_D_and_K")
model.addConstr(5*x1 + 5*x2 >= 6, name="cardiovascular_support_potassium_and_vitamin_K")

# Cognitive performance index constraints
model.addConstr(3*x0 + 2*x1 + 5*x2 >= 6, name="cognitive_performance_index_total")
model.addConstr(3*x0 + 5*x2 >= 3, name="cognitive_performance_vitamin_D_and_vitamin_K")
model.addConstr(2*x1 + 5*x2 >= 4, name="cognitive_performance_potassium_and_vitamin_K")

# Immune support index constraints
model.addConstr(x0 + x1 + 4*x2 >= 5, name="immune_support_index_total")
model.addConstr(x1 + 4*x2 >= 2, name="immune_support_potassium_and_vitamin_K")
model.addConstr(x0 + 4*x2 >= 6, name="immune_support_vitamin_D_and_vitamin_K")

# Energy stability index constraints
model.addConstr(x0 + 5*x1 + 2*x2 >= 8, name="energy_stability_index_total")
model.addConstr(5*x1 + 2*x2 >= 4, name="energy_stability_potassium_and_vitamin_K")
model.addConstr(x0 + 5*x1 >= 2, name="energy_stability_vitamin_D_and_potassium")

# Additional constraints
model.addConstr(-7*x0 + 8*x1 >= 0, name="additional_constraint_1")
model.addConstr(-7*x0 + 2*x2 >= 0, name="additional_constraint_2")

# Upper bounds for the total combined indices (if applicable)
model.addConstr(3*x0 + 2*x1 + 5*x2 <= 14, name="cognitive_performance_upper_bound")
model.addConstr(x0 + x1 + 4*x2 <= 10, name="immune_support_upper_bound")
model.addConstr(x0 + 2*x2 <= 15, name="energy_stability_vitamin_D_and_vitamin_K_upper_bound")
model.addConstr(5*x1 + 2*x2 <= 13, name="energy_stability_potassium_and_vitamin_K_upper_bound")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of Vitamin D: {x0.X}")
    print(f"Milligrams of Potassium: {x1.X}")
    print(f"Milligrams of Vitamin K: {x2.X}")
else:
    print("No optimal solution found.")
