
import gurobi

def optimize():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="vitamin_D", vtype=gurobi.GRB.INTEGER)  # Milligrams of vitamin D
    x1 = model.addVar(name="potassium", vtype=gurobi.GRB.CONTINUOUS)  # Milligrams of potassium
    x2 = model.addVar(name="vitamin_K", vtype=gurobi.GRB.INTEGER)  # Milligrams of vitamin K

    # Objective function
    model.setObjective(8 * x0 + 3 * x1 + x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x0 <= 22, name="r0_constraint")
    model.addConstr(3 * x0 <= 50, name="r1_constraint")
    model.addConstr(3 * x0 <= 18, name="r2_constraint")
    model.addConstr(x0 <= 19, name="r3_constraint")
    model.addConstr(x0 <= 25, name="r4_constraint")

    model.addConstr(3 * x1 <= 22, name="r0_constraint_x1")
    model.addConstr(5 * x1 <= 50, name="r1_constraint_x1")
    model.addConstr(2 * x1 <= 18, name="r2_constraint_x1")
    model.addConstr(x1 <= 19, name="r3_constraint_x1")
    model.addConstr(5 * x1 <= 25, name="r4_constraint_x1")

    model.addConstr(x2 <= 22, name="r0_constraint_x2")
    model.addConstr(5 * x2 <= 50, name="r1_constraint_x2")
    model.addConstr(5 * x2 <= 18, name="r2_constraint_x2")
    model.addConstr(4 * x2 <= 19, name="r3_constraint_x2")
    model.addConstr(2 * x2 <= 25, name="r4_constraint_x2")

    model.addConstr(3 * x0 + 3 * x1 >= 2, name="combined_digestive_support")
    model.addConstr(3 * x1 + x2 >= 7, name="combined_digestive_support_2")
    model.addConstr(3 * x0 + 3 * x1 + x2 >= 7, name="combined_digestive_support_3")

    model.addConstr(5 * x1 + 5 * x2 >= 6, name="combined_cardiovascular_support_2")
    model.addConstr(3 * x0 + 5 * x2 >= 9, name="combined_cardiovascular_support_3")
    model.addConstr(3 * x0 + 5 * x1 + 5 * x2 >= 9, name="combined_cardiovascular_support_4")

    model.addConstr(3 * x0 + 5 * x2 >= 3, name="combined_cognitive_performance_2")
    model.addConstr(2 * x1 + 5 * x2 >= 4, name="combined_cognitive_performance_3")
    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 >= 6, name="combined_cognitive_performance_4")

    model.addConstr(x1 + 4 * x2 >= 2, name="combined_immune_support_2")
    model.addConstr(x0 + 4 * x2 >= 6, name="combined_immune_support_3")
    model.addConstr(x0 + x1 + 4 * x2 >= 5, name="combined_immune_support_4")

    model.addConstr(5 * x1 + 2 * x2 >= 4, name="combined_energy_stability_2")
    model.addConstr(x0 + 5 * x1 >= 2, name="combined_energy_stability_3")
    model.addConstr(x0 + x1 + 2 * x2 >= 8, name="combined_energy_stability_4")

    model.addConstr(-7 * x0 + 8 * x1 >= 0, name="linear_constraint_1")
    model.addConstr(-7 * x0 + 2 * x2 >= 0, name="linear_constraint_2")

    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 <= 14, name="upper_bound_cognitive")
    model.addConstr(x0 + x1 + 4 * x2 <= 10, name="upper_bound_immune")
    model.addConstr(x0 + 2 * x2 <= 15, name="upper_bound_energy_1")
    model.addConstr(5 * x1 + 2 * x2 <= 13, name="upper_bound_energy_2")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Vitamin D: ", x0.varValue)
        print("Potassium: ", x1.varValue)
        print("Vitamin K: ", x2.varValue)
    else:
        print("No optimal solution found")

optimize()
