
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
sunflowers = m.addVar(vtype=GRB.INTEGER, name="sunflowers")
cherry_trees = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")
basil_plants = m.addVar(vtype=GRB.INTEGER, name="basil_plants")

# Define the objective function
m.setObjective(1.28 * sunflowers + 1.29 * cherry_trees + 3.61 * basil_plants, GRB.MINIMIZE)

# Add constraints
# Resilience index and yield constraints are implicitly considered in combined constraints

# Combined resilience index constraints
m.addConstr(3.98 * sunflowers + 8.04 * basil_plants >= 23, name="resilience_index_sun_basil")
m.addConstr(3.98 * sunflowers + 4.75 * cherry_trees + 8.04 * basil_plants >= 23, name="total_resilience_index")

# Yield constraints
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees >= 47, name="yield_sun_cherry")
m.addConstr(11.98 * cherry_trees + 11.92 * basil_plants >= 56, name="yield_cherry_basil")
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees + 11.92 * basil_plants >= 57, name="total_yield")

# Additional linear inequality constraints
m.addConstr(-5 * cherry_trees + 2 * basil_plants >= 0, name="cherry_basil_constraint")
m.addConstr(4 * sunflowers - 3 * basil_plants >= 0, name="sunflower_basil_constraint")

# Upper bound on combined yields
m.addConstr(1.58 * sunflowers + 11.98 * cherry_trees <= 88, name="yield_sun_cherry_upper")
m.addConstr(1.58 * sunflowers + 11.92 * basil_plants <= 76, name="yield_sun_basil_upper")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sunflowers: {sunflowers.x}")
    print(f"Cherry Trees: {cherry_trees.x}")
    print(f"Basil Plants: {basil_plants.x}")
else:
    print("No optimal solution found")
