
import gurobipy as gp

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
sunflowers = model.addVar(name="sunflowers", integer=True)
cherry_trees = model.addVar(name="cherry_trees", integer=True)
basil_plants = model.addVar(name="basil_plants", integer=True)

# Objective function
model.setObjective(1.28 * sunflowers + 1.29 * cherry_trees + 3.61 * basil_plants, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(3.98 * sunflowers + 8.04 * basil_plants >= 23, name="resilience_sunflowers_basil")
model.addConstr(3.98 * sunflowers + 4.75 * cherry_trees + 8.04 * basil_plants >= 23, name="resilience_all")
model.addConstr(1.58 * sunflowers + 11.98 * cherry_trees >= 47, name="yield_sunflowers_cherry")
model.addConstr(11.98 * cherry_trees + 11.92 * basil_plants >= 56, name="yield_cherry_basil")
model.addConstr(1.58 * sunflowers + 11.98 * cherry_trees + 11.92 * basil_plants >= 57, name="yield_all")
model.addConstr(-5 * cherry_trees + 2 * basil_plants >= 0, name="cherry_basil_tradeoff")
model.addConstr(4 * sunflowers - 3 * basil_plants >= 0, name="sunflowers_basil_tradeoff")
model.addConstr(1.58 * sunflowers + 11.98 * cherry_trees <= 88, name="yield_sunflowers_cherry_limit")
model.addConstr(1.58 * sunflowers + 11.92 * basil_plants <= 76, name="yield_sunflowers_basil_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Sunflowers: {sunflowers.varValue}")
    print(f"Cherry Trees: {cherry_trees.varValue}")
    print(f"Basil Plants: {basil_plants.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
