
import gurobipy as gp

# Create a new model
m = gp.Model("sourness_optimization")

# Create variables
ravioli = m.addVar(lb=0, name="ravioli")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
blueberry_pies = m.addVar(lb=0, name="blueberry_pies")
pickles = m.addVar(lb=0, name="pickles")
sashimi = m.addVar(lb=0, name="sashimi")

# Set objective function
m.setObjective(6.4 * ravioli + 3.16 * ham_sandwiches + 8.42 * blueberry_pies + 5.54 * pickles + 1.86 * sashimi, gp.GRB.MINIMIZE)

# Add constraints
sourness_index = {'ravioli': 20, 'ham_sandwiches': 19, 'blueberry_pies': 11, 'pickles': 13, 'sashimi': 12}
m.addConstr(sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['pickles'] * pickles >= 16)
m.addConstr(sourness_index['ham_sandwiches'] * ham_sandwiches + sourness_index['pickles'] * pickles >= 20)
m.addConstr(sourness_index['ravioli'] * ravioli + sourness_index['pickles'] * pickles + sourness_index['sashimi'] * sashimi >= 28)
m.addConstr(sourness_index['ham_sandwiches'] * ham_sandwiches + sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['pickles'] * pickles >= 28)
m.addConstr(sourness_index['ham_sandwiches'] * ham_sandwiches + sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['sashimi'] * sashimi >= 28)
m.addConstr(sourness_index['ravioli'] * ravioli + sourness_index['ham_sandwiches'] * ham_sandwiches + sourness_index['pickles'] * pickles >= 28)
m.addConstr(sourness_index['ravioli'] * ravioli + sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['pickles'] * pickles >= 28)
m.addConstr(sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['pickles'] * pickles + sourness_index['sashimi'] * sashimi >= 28)
m.addConstr(sourness_index['ravioli'] * ravioli + sourness_index['ham_sandwiches'] * ham_sandwiches + sourness_index['blueberry_pies'] * blueberry_pies + sourness_index['pickles'] * pickles + sourness_index['sashimi'] * sashimi >= 28)
m.addConstr(-8 * ravioli + 7 * blueberry_pies >= 0)
m.addConstr(8 * ravioli - 4 * sashimi >= 0)
m.addConstr(sourness_index['pickles'] * pickles + sourness_index['sashimi'] * sashimi <= 136)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

