
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
ravioli = m.addVar(name="ravioli", lb=0)  # No lower bound, can be negative, but we set to 0 for practical purposes
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0)
blueberry_pies = m.addVar(name="blueberry_pies", lb=0)
pickles = m.addVar(name="pickles", lb=0)
sashimi = m.addVar(name="sashimi", lb=0)

# Define the objective function
m.setObjective(6.4 * ravioli + 3.16 * ham_sandwiches + 8.42 * blueberry_pies + 5.54 * pickles + 1.86 * sashimi, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles + 12 * sashimi <= 145)
m.addConstr(11 * blueberry_pies + 13 * pickles >= 16)
m.addConstr(19 * ham_sandwiches + 13 * pickles >= 20)
m.addConstr(20 * ravioli + 13 * pickles + 12 * sashimi >= 17)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles >= 17)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 12 * sashimi >= 17)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 13 * pickles >= 17)
m.addConstr(20 * ravioli + 11 * blueberry_pies + 13 * pickles >= 17)
m.addConstr(11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 17)
m.addConstr(20 * ravioli + 13 * pickles + 12 * sashimi >= 15)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles >= 15)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 12 * sashimi >= 15)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 13 * pickles >= 15)
m.addConstr(20 * ravioli + 11 * blueberry_pies + 13 * pickles >= 15)
m.addConstr(11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 15)
m.addConstr(20 * ravioli + 13 * pickles + 12 * sashimi >= 17)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles >= 17)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 12 * sashimi >= 17)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 13 * pickles >= 17)
m.addConstr(20 * ravioli + 11 * blueberry_pies + 13 * pickles >= 17)
m.addConstr(11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 17)
m.addConstr(20 * ravioli + 13 * pickles + 12 * sashimi >= 19)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles >= 19)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 12 * sashimi >= 19)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 13 * pickles >= 19)
m.addConstr(20 * ravioli + 11 * blueberry_pies + 13 * pickles >= 19)
m.addConstr(11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 19)
m.addConstr(20 * ravioli + 13 * pickles + 12 * sashimi >= 28)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles >= 28)
m.addConstr(19 * ham_sandwiches + 11 * blueberry_pies + 12 * sashimi >= 28)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 13 * pickles >= 28)
m.addConstr(20 * ravioli + 11 * blueberry_pies + 13 * pickles >= 28)
m.addConstr(11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 28)
m.addConstr(20 * ravioli + 19 * ham_sandwiches + 11 * blueberry_pies + 13 * pickles + 12 * sashimi >= 28)
m.addConstr(-8 * ravioli + 7 * blueberry_pies >= 0)
m.addConstr(8 * ravioli - 4 * sashimi >= 0)
m.addConstr(13 * pickles + 12 * sashimi <= 136)

# Solve the model
m.optimize()

# Print the results
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {ravioli.varValue}")
    print(f"Ham sandwiches: {ham_sandwiches.varValue}")
    print(f"Blueberry pies: {blueberry_pies.varValue}")
    print(f"Pickles: {pickles.varValue}")
    print(f"Sashimi: {sashimi.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
