
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
squash_plants = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
coleus = m.addVar(vtype=GRB.INTEGER, name="coleus")
hydrangeas = m.addVar(vtype=GRB.INTEGER, name="hydrangeas")
cherry_trees = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")

# Set objective function
m.setObjective(4*squash_plants**2 + 3*squash_plants*coleus + 5*squash_plants*hydrangeas + 8*squash_plants*cherry_trees + 8*coleus**2 + 9*coleus*hydrangeas + 6*coleus*cherry_trees + 3*squash_plants + 6*cherry_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*squash_plants + 12*hydrangeas + 17*cherry_trees >= 18, "c1")
m.addConstr(15*squash_plants**2 + 28*coleus**2 + 17*cherry_trees**2 >= 18, "c2")
m.addConstr(15*squash_plants + 28*coleus + 12*hydrangeas >= 18, "c3")
m.addConstr(28*coleus + 12*hydrangeas + 17*cherry_trees >= 18, "c4")
m.addConstr(15*squash_plants + 12*hydrangeas + 17*cherry_trees >= 34, "c5")
m.addConstr(15*squash_plants + 28*coleus + 17*cherry_trees >= 34, "c6")
m.addConstr(15*squash_plants + 28*coleus + 12*hydrangeas >= 34, "c7")
m.addConstr(28*coleus + 12*hydrangeas + 17*cherry_trees >= 34, "c8")
m.addConstr(15*squash_plants**2 + 12*hydrangeas**2 + 17*cherry_trees**2 >= 19, "c9")
m.addConstr(15*squash_plants + 28*coleus + 17*cherry_trees >= 19, "c10")
m.addConstr(15*squash_plants + 28*coleus + 12*hydrangeas >= 19, "c11")
m.addConstr(28*coleus + 12*hydrangeas + 17*cherry_trees >= 19, "c12")
m.addConstr(15*squash_plants + 12*hydrangeas + 17*cherry_trees >= 34, "c13")
m.addConstr(15*squash_plants + 28*coleus + 17*cherry_trees >= 34, "c14")
m.addConstr(15*squash_plants + 28*coleus + 12*hydrangeas >= 34, "c15")
m.addConstr(28*coleus**2 + 12*hydrangeas**2 + 17*cherry_trees**2 >= 34, "c16")

m.addConstr(21*coleus + 29*hydrangeas + 14*cherry_trees >= 19, "c17")
m.addConstr(4*squash_plants**2 - 3*coleus**2 - hydrangeas**2 >= 0, "c18")
m.addConstr(12*hydrangeas**2 + 17*cherry_trees**2 <= 78, "c19")
m.addConstr(28*coleus + 17*cherry_trees <= 94, "c20")
m.addConstr(15*squash_plants**2 + 12*hydrangeas**2 <= 111, "c21")
m.addConstr(15*squash_plants + 28*coleus + 12*hydrangeas + 17*cherry_trees <= 111, "c22")
m.addConstr(21*coleus + 14*cherry_trees <= 47, "c23")
m.addConstr(27*squash_plants + 14*cherry_trees <= 65, "c24")
m.addConstr(27*squash_plants + 29*hydrangeas + 14*cherry_trees <= 65, "c25")
m.addConstr(27*squash_plants + 21*coleus + 29*hydrangeas <= 78, "c26")
m.addConstr(27*squash_plants**2 + 21*coleus**2 + 14*cherry_trees**2 <= 87, "c27")
m.addConstr(27*squash_plants + 21*coleus + 29*hydrangeas + 14*cherry_trees <= 87, "c28")


m.addConstr(15*squash_plants <= 147, "water_squash")
m.addConstr(28*coleus <= 147, "water_coleus")
m.addConstr(12*hydrangeas <= 147, "water_hydrangeas")
m.addConstr(17*cherry_trees <= 147, "water_cherry_trees")

m.addConstr(27*squash_plants <= 102, "cost_squash")
m.addConstr(21*coleus <= 102, "cost_coleus")
m.addConstr(29*hydrangeas <= 102, "cost_hydrangeas")
m.addConstr(14*cherry_trees <= 102, "cost_cherry_trees")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

