
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="squash_plants", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="coleus", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hydrangeas", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="cherry_trees", vtype=gurobi.GRB.INTEGER)
    
    # Objective function
    model.setObjective(4*x0**2 + 3*x0*x1 + 5*x0*x2 + 8*x0*x3 + 8*x1**2 + 9*x1*x2 + 6*x1*x3 + 3*x0 + 6*x3, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(15*x0 + 28*x1 + 12*x2 + 17*x3 <= 147)
    model.addConstr(27*x0 + 21*x1 + 29*x2 + 14*x3 <= 102)
    model.addConstr(15*x0 + 12*x2 + 17*x3 >= 18)
    model.addConstr(15**2*x0**2 + 28**2*x1**2 + 17**2*x3**2 >= 18)
    model.addConstr(15*x0 + 28*x1 + 12*x2 >= 18)
    model.addConstr(28*x1 + 12*x2 + 17*x3 >= 18)
    model.addConstr(15*x0 + 12*x2 + 17*x3 >= 34)
    model.addConstr(15*x0 + 28*x1 + 17*x3 >= 34)
    model.addConstr(15*x0 + 28*x1 + 12*x2 >= 34)
    model.addConstr(28*x1 + 12*x2 + 17*x3 >= 34)
    model.addConstr(15**2*x0**2 + 12**2*x2**2 + 17**2*x3**2 >= 19)
    model.addConstr(15*x0 + 28*x1 + 17*x3 >= 19)
    model.addConstr(15*x0 + 28*x1 + 12*x2 >= 19)
    model.addConstr(28*x1 + 12*x2 + 17*x3 >= 19)
    model.addConstr(15*x0 + 12*x2 + 17*x3 >= 34)
    model.addConstr(15*x0 + 28*x1 + 17*x3 >= 34)
    model.addConstr(15*x0 + 28*x1 + 12*x2 >= 34)
    model.addConstr(28**2*x1**2 + 12**2*x2**2 + 17**2*x3**2 >= 34)
    model.addConstr(21*x1 + 29*x2 + 14*x3 >= 19)
    model.addConstr(4*x0**2 - 3*x1**2 - x2**2 >= 0)
    model.addConstr(12**2*x2**2 + 17**2*x3**2 <= 78)
    model.addConstr(28*x1 + 17*x3 <= 94)
    model.addConstr(15**2*x0**2 + 12**2*x2**2 <= 111)
    model.addConstr(15*x0 + 28*x1 + 12*x2 + 17*x3 <= 111)
    model.addConstr(21*x1 + 14*x3 <= 47)
    model.addConstr(27*x0 + 14*x3 <= 65)
    model.addConstr(27*x0 + 29*x2 + 14*x3 <= 65)
    model.addConstr(27*x0 + 21*x1 + 29*x2 <= 78)
    model.addConstr(27**2*x0**2 + 21**2*x1**2 + 14**2*x3**2 <= 87)
    model.addConstr(27*x0 + 21*x1 + 29*x2 + 14*x3 <= 87)
    
    # Solve the problem
    model.optimize()
    
    # Output the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("squash plants: ", x0.varValue)
        print("coleus: ", x1.varValue)
        print("hydrangeas: ", x2.varValue)
        print("cherry trees: ", x3.varValue)
    else:
        print("The problem is infeasible")

optimize_problem()
