
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
protein_bars = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein_bars")
cornichons = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cornichons")
chicken_thighs = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
chicken_breasts = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(2 * protein_bars + 8 * cornichons + 5 * chicken_thighs + 7 * chicken_breasts, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * protein_bars + 11 * chicken_thighs >= 30, "c1")
m.addConstr(4 * protein_bars + 3 * cornichons >= 18, "c2")
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 35, "c3")
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 35, "c4")
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 35, "c5")
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 36, "c6")
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 36, "c7")
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 36, "c8")
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 31, "c9")
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 31, "c10")
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 31, "c11")
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 31, "c12")
m.addConstr(5 * chicken_thighs + 11 * chicken_breasts >= 104, "c13")
m.addConstr(10 * protein_bars + 12 * cornichons >= 53, "c14")
m.addConstr(12 * cornichons + 11 * chicken_breasts >= 80, "c15")
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 64, "c16")
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 64, "c17")
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 64, "c18")
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 58, "c19")
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 58, "c20")
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 58, "c21")
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 97, "c22")
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 97, "c23")
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 97, "c24")
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 97, "c25")
m.addConstr(5 * protein_bars - 5 * chicken_thighs >= 0, "c26")
m.addConstr(1 * protein_bars - 3 * cornichons >= 0, "c27")
m.addConstr(4 * protein_bars + 3 * cornichons <= 83, "c28")
m.addConstr(4 * protein_bars + 10 * chicken_breasts <= 141, "c29")
m.addConstr(3 * cornichons + 11 * chicken_thighs <= 54, "c30")
m.addConstr(11 * chicken_thighs + 10 * chicken_breasts <= 148, "c31")
m.addConstr(4 * protein_bars + 11 * chicken_thighs <= 96, "c32")
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts <= 284, "c33")
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs <= 264, "c34")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

