
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
protein_bars = m.addVar(name="protein_bars", lb=0)
cornichons = m.addVar(name="cornichons", lb=0)
chicken_thighs = m.addVar(name="chicken_thighs", lb=0)
chicken_breasts = m.addVar(name="chicken_breasts", lb=0)

# Define the objective function
m.setObjective(2 * protein_bars + 8 * cornichons + 5 * chicken_thighs + 7 * chicken_breasts, gp.GRB.MINIMIZE)

# Add constraints
# Sourness index constraints
m.addConstr(4 * protein_bars + 11 * chicken_thighs >= 30)
m.addConstr(4 * protein_bars + 3 * cornichons >= 18)
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 35)
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 35)
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 35)
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 36)
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 36)
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 36)
m.addConstr(4 * protein_bars + 11 * chicken_thighs + 10 * chicken_breasts >= 31)
m.addConstr(3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 31)
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs >= 31)
m.addConstr(4 * protein_bars + 3 * cornichons + 11 * chicken_thighs + 10 * chicken_breasts >= 31)

# Umami index constraints
m.addConstr(5 * chicken_thighs + 11 * chicken_breasts >= 104)
m.addConstr(10 * protein_bars + 12 * cornichons >= 53)
m.addConstr(12 * cornichons + 11 * chicken_breasts >= 80)
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 64)
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 64)
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 64)
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 58)
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 58)
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 58)
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs >= 97)
m.addConstr(12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 97)
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts >= 97)
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs + 11 * chicken_breasts >= 97)

# Linear constraints
m.addConstr(5 * protein_bars - 5 * chicken_thighs >= 0)
m.addConstr(protein_bars - 3 * cornichons >= 0)

# Upper bound constraints
m.addConstr(4 * protein_bars + 3 * cornichons <= 83)
m.addConstr(4 * protein_bars + 10 * chicken_breasts <= 141)
m.addConstr(3 * cornichons + 11 * chicken_thighs <= 54)
m.addConstr(11 * chicken_thighs + 10 * chicken_breasts <= 148)
m.addConstr(4 * protein_bars + 11 * chicken_thighs <= 96)
m.addConstr(10 * protein_bars + 12 * cornichons + 11 * chicken_breasts <= 284)
m.addConstr(10 * protein_bars + 12 * cornichons + 5 * chicken_thighs <= 264)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {protein_bars.varValue}")
    print(f"Cornichons: {cornichons.varValue}")
    print(f"Chicken thighs: {chicken_thighs.varValue}")
    print(f"Chicken breasts: {chicken_breasts.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
