
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="calcium", vtype=gurobi.GRB.INTEGER, lb=0)
    x1 = model.addVar(name="vitamin_B1", vtype=gurobi.GRB.CONTINUOUS, lb=0)
    x2 = model.addVar(name="zinc", vtype=gurobi.GRB.INTEGER, lb=0)
    x3 = model.addVar(name="vitamin_B7", vtype=gurobi.GRB.INTEGER, lb=0)
    x4 = model.addVar(name="vitamin_D", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(8*x0 + 7*x1 + 2*x2 + 9*x3 + 3*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x0 + 17*x1 >= 16, name="muscle_growth_constraint1")
    model.addConstr(12*x0 + 3*x3 >= 10, name="muscle_growth_constraint2")
    model.addConstr(4*x2 + 3*x3 >= 12, name="muscle_growth_constraint3")
    model.addConstr(3*x2 + 17*x4 >= 10, name="kidney_support_constraint1")
    model.addConstr(13*x1 + 17*x4 >= 20, name="kidney_support_constraint2")
    model.addConstr(9*x0 + 3*x2 >= 21, name="kidney_support_constraint3")
    model.addConstr(15*x0 + 13*x3 + 6*x4 >= 19, name="cardiovascular_support_constraint1")
    model.addConstr(11*x3 + 3*x4 >= 24, name="cognitive_performance_constraint")
    model.addConstr(x0 + 14*x2 + 8*x3 >= 22, name="digestive_support_constraint1")
    model.addConstr(4*x2 + 3*x3 <= 108, name="muscle_growth_limit_constraint1")
    model.addConstr(12*x0 + 17*x1 + 4*x2 + 3*x3 + x4 <= 114, name="resource_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Calcium: ", x0.varValue)
        print("Vitamin B1: ", x1.varValue)
        print("Zinc: ", x2.varValue)
        print("Vitamin B7: ", x3.varValue)
        print("Vitamin D: ", x4.varValue)
    else:
        print("No optimal solution found.")

optimize()
