
from gurobipy import Model, GRB

# Create a new model
model = Model("calcium_optimization")

# Create variables
chicken_thighs = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
apple_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
knishes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knishes")

# Set objective function
model.setObjective(3 * chicken_thighs + 2 * apple_pies + 6 * knishes, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * chicken_thighs + 19 * apple_pies >= 57, "calcium_constraint1")
model.addConstr(6 * chicken_thighs + 17 * knishes >= 59, "calcium_constraint2")
model.addConstr(6 * chicken_thighs + 19 * apple_pies + 17 * knishes >= 59, "calcium_constraint3")
model.addConstr(-10 * chicken_thighs + 1 * apple_pies >= 0, "constraint4")
model.addConstr(6 * chicken_thighs + 19 * apple_pies + 17 * knishes <= 252, "calcium_upper_bound")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective:', model.objVal)
    print('chicken_thighs:', chicken_thighs.x)
    print('apple_pies:', apple_pies.x)
    print('knishes:', knishes.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization terminated with status {model.status}")

