
from gurobipy import *

# Create a new model
m = Model("Calcium_Optimization")

# Define the decision variables as continuous
x0 = m.addVar(vtype=GRB.CONTINUOUS, name='chicken_thighs')
x1 = m.addVar(vtype=GRB.CONTINUOUS, name='apple_pies')
x2 = m.addVar(vtype=GRB.CONTINUOUS, name='knishes')

# Define the objective function
m.setObjective(3*x0 + 2*x1 + 6*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x0 + 19*x1 >= 57, 'calcium_from_chicken_and_pies')
m.addConstr(6*x0 + 17*x2 >= 59, 'calcium_from_chicken_and_knishes')
m.addConstr(6*x0 + 19*x1 + 17*x2 >= 59, 'calcium_from_all_items')
m.addConstr(-10*x0 + x1 >= 0, 'chicken_thighs_vs_apple_pies')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken thighs: {x0.x}")
    print(f"Apple pies: {x1.x}")
    print(f"Knishes: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
