
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
chicken_thighs = m.addVar(name="chicken_thighs", lb=0)  # Lower bound is 0, not necessarily integer
apple_pies = m.addVar(name="apple_pies", lb=0)  # Lower bound is 0, not necessarily integer
knishes = m.addVar(name="knishes", lb=0)  # Lower bound is 0, not necessarily integer

# Objective function
m.setObjective(3 * chicken_thighs + 2 * apple_pies + 6 * knishes, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(6 * chicken_thighs + 19 * apple_pies >= 57, name="calcium_from_chicken_and_pies")
m.addConstr(6 * chicken_thighs + 17 * knishes >= 59, name="calcium_from_chicken_and_knishes")
m.addConstr(6 * chicken_thighs + 19 * apple_pies + 17 * knishes >= 59, name="total_calcium")
m.addConstr(-10 * chicken_thighs + apple_pies >= 0, name="chicken_and_pie_relation")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken Thighs: ", chicken_thighs.varValue)
    print("Apple Pies: ", apple_pies.varValue)
    print("Knishes: ", knishes.varValue)
else:
    print("The model is infeasible")
