
import gurobipy as gp

# Create a new model
m = gp.Model("storage_optimization")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="blue_highlighters") # Integer amount
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="staplers") # Integer amount
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="cafeteria_chairs") # Integer amount


# Set objective function
m.setObjective(5*x0 + 8*x1 + 3*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.11 * x1 + 7.99 * x2 <= 61, "staplers_chairs_space")
m.addConstr(3.05 * x0 + 7.99 * x2 <= 22, "highlighters_chairs_space")
m.addConstr(3.05 * x0 + 0.11 * x1 + 7.99 * x2 <= 57, "total_space")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('blue_highlighters:', x0.x)
    print('staplers:', x1.x)
    print('cafeteria_chairs:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

