
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="blue_highlighters")
x1 = m.addVar(vtype=GRB.INTEGER, name="staplers")
x2 = m.addVar(vtype=GRB.INTEGER, name="cafeteria_chairs")

# Set the objective function
m.setObjective(5*x0 + 8*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.11*x1 + 7.99*x2 <= 61, "staplers_and_chairs")
m.addConstr(3.05*x0 + 7.99*x2 <= 22, "highlighters_and_chairs")
m.addConstr(3.05*x0 + 0.11*x1 + 7.99*x2 <= 57, "total_storage")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue Highlighters: {x0.x}")
    print(f"Staplers: {x1.x}")
    print(f"Cafeteria Chairs: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
