
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="blue_highlighters", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="staplers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cafeteria_chairs", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 5*x0 + 8*x1 + 3*x2
    model.setObjective(5*x0 + 8*x1 + 3*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.05*x0 + 0.11*x1 + 7.99*x2 <= 67, name="storage_space")
    model.addConstr(x0 >= 0, name="x0_non_negative")
    model.addConstr(x1 >= 0, name="x1_non_negative")
    model.addConstr(x2 >= 0, name="x2_non_negative")

    # Additional constraints if strictly necessary can be added here, 
    # but given the problem statement, they seem redundant or less specific than the total

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Blue highlighters: {x0.varValue}")
        print(f"Staplers: {x1.varValue}")
        print(f"Cafeteria chairs: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
