
from gurobipy import Model, GRB

# Create a new model
model = Model("PlantOptimization")

# Create variables
chili_plants = model.addVar(vtype=GRB.INTEGER, name="chili_plants")
carnations = model.addVar(vtype=GRB.INTEGER, name="carnations")
sunflowers = model.addVar(vtype=GRB.INTEGER, name="sunflowers")
peonies = model.addVar(vtype=GRB.INTEGER, name="peonies")
agave = model.addVar(vtype=GRB.INTEGER, name="agave")

# Set objective function
model.setObjective(3 * chili_plants + 5 * carnations + 9 * sunflowers + 2 * peonies + 9 * agave, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers + 4 * peonies + 8 * agave <= 138, "Water_Need")  # Total water need
model.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers + 4 * peonies + 8 * agave <= 87, "Resilience_Index")  # Total resilience index

model.addConstr(6 * sunflowers + 4 * peonies >= 19, "Water_Sunflowers_Peonies")
model.addConstr(3 * chili_plants + 8 * agave >= 26, "Water_Chili_Agave")
model.addConstr(10 * carnations + 6 * sunflowers >= 25, "Water_Carnations_Sunflowers")

model.addConstr(9 * sunflowers + 4 * peonies >= 10, "Resilience_Sunflowers_Peonies")
model.addConstr(9 * sunflowers + 8 * agave >= 11, "Resilience_Sunflowers_Agave")
model.addConstr(6 * chili_plants + 4 * peonies >= 14, "Resilience_Chili_Peonies")
model.addConstr(10 * carnations + 9 * sunflowers >= 5, "Resilience_Carnations_Sunflowers")
model.addConstr(6 * chili_plants + 10 * carnations + 4 * peonies >= 17, "Resilience_Chili_Carnations_Peonies")
model.addConstr(6 * chili_plants + 10 * carnations + 8 * agave >= 17, "Resilience_Chili_Carnations_Agave")
model.addConstr(6 * chili_plants + 4 * peonies + 8 * agave >= 17, "Resilience_Chili_Peonies_Agave")
model.addConstr(6 * chili_plants + 9 * sunflowers + 4 * peonies >= 17, "Resilience_Chili_Sunflowers_Peonies")


model.addConstr(2 * chili_plants + 3 * carnations - 2 * peonies >= 0, "Plant_Combination")

model.addConstr(4 * peonies + 8 * agave <= 72, "Water_Peonies_Agave")
model.addConstr(3 * chili_plants + 4 * peonies <= 52, "Water_Chili_Peonies")
model.addConstr(10 * carnations + 4 * peonies <= 74, "Water_Carnations_Peonies")
model.addConstr(3 * chili_plants + 10 * carnations <= 98, "Water_Chili_Carnations")
model.addConstr(6 * sunflowers + 8 * agave <= 63, "Water_Sunflowers_Agave")
model.addConstr(3 * chili_plants + 6 * sunflowers <= 42, "Water_Chili_Sunflowers")
model.addConstr(3 * chili_plants + 6 * sunflowers + 4 * peonies <= 83, "Water_Chili_Sunflowers_Peonies")
model.addConstr(6 * sunflowers + 4 * peonies + 8 * agave <= 68, "Water_Sunflowers_Peonies_Agave")
model.addConstr(3 * chili_plants + 4 * peonies + 8 * agave <= 81, "Water_Chili_Peonies_Agave")
model.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers <= 121, "Water_Chili_Carnations_Sunflowers")
model.addConstr(3 * chili_plants + 10 * carnations + 8 * agave <= 129, "Water_Chili_Carnations_Agave")
model.addConstr(10 * carnations + 6 * sunflowers + 4 * peonies <= 83, "Water_Carnations_Sunflowers_Peonies")
model.addConstr(10 * carnations + 6 * sunflowers + 8 * agave <= 115, "Water_Carnations_Sunflowers_Agave")
model.addConstr(3 * chili_plants + 10 * carnations + 6 * sunflowers + 4 * peonies + 8 * agave <= 115, "Total_Water_Need")

model.addConstr(9 * sunflowers + 4 * peonies <= 59, "Resilience_Max_Sunflowers_Peonies")
model.addConstr(6 * chili_plants + 9 * sunflowers <= 23, "Resilience_Max_Chili_Sunflowers")
model.addConstr(6 * chili_plants + 9 * sunflowers + 4 * peonies <= 82, "Resilience_Max_Chili_Sunflowers_Peonies")
model.addConstr(9 * sunflowers + 4 * peonies + 8 * agave <= 87, "Resilience_Max_Sunflowers_Peonies_Agave")
model.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers <= 21, "Resilience_Max_Chili_Carnations_Sunflowers")
model.addConstr(6 * chili_plants + 10 * carnations + 4 * peonies <= 72, "Resilience_Max_Chili_Carnations_Peonies")
model.addConstr(6 * chili_plants + 9 * sunflowers + 8 * agave <= 26, "Resilience_Max_Chili_Sunflowers_Agave")
model.addConstr(6 * chili_plants + 10 * carnations + 9 * sunflowers + 4 * peonies + 8 * agave <= 26, "Total_Resilience")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Objective value:", model.objVal)
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

