
from gurobipy import *

# Create a model
m = Model("Plant_Optimization")

# Define the decision variables
chili_plants = m.addVar(vtype=GRB.INTEGER, name="chili_plants")
carnations = m.addVar(vtype=GRB.INTEGER, name="carnations")
sunflowers = m.addVar(vtype=GRB.INTEGER, name="sunflowers")
peonies = m.addVar(vtype=GRB.INTEGER, name="peonies")
agave = m.addVar(vtype=GRB.INTEGER, name="agave")

# Objective function
m.setObjective(3*chili_plants + 5*carnations + 9*sunflowers + 2*peonies + 9*agave, GRB.MAXIMIZE)

# Constraints
# Water need constraints
m.addConstr(3*chili_plants + 8*agave >= 26, name="water_chili_agave")
m.addConstr(10*carnations + 6*sunflowers >= 25, name="water_carnation_sunflower")
m.addConstr(6*sunflowers + 4*peonies >= 19, name="water_sunflower_peony")

# Total water availability constraints
m.addConstr(3*chili_plants + 10*carnations <= 98, name="total_water_chili_carnation")
m.addConstr(10*carnations + 4*peonies <= 74, name="total_water_carnation_peony")
m.addConstr(6*sunflowers + 8*agave <= 63, name="total_water_sunflower_agave")

# Resilience index constraints
m.addConstr(6*chili_plants + 4*peonies >= 14, name="resilience_chili_peony")
m.addConstr(10*carnations + 9*sunflowers >= 5, name="resilience_carnation_sunflower")

# Non-negativity constraints
m.addConstr(chili_plants >= 0, name="non_neg_chili")
m.addConstr(carnations >= 0, name="non_neg_carnation")
m.addConstr(sunflowers >= 0, name="non_neg_sunflower")
m.addConstr(peonies >= 0, name="non_neg_peony")
m.addConstr(agave >= 0, name="non_neg_agave")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
