
import gurobipy as gp

# Create a new model
m = gp.Model("carbohydrate_optimization")

# Create variables
peanutbutter_sandwiches = m.addVar(lb=0, name="peanutbutter_sandwiches")
pickles = m.addVar(lb=0, name="pickles")
bowls_of_cereal = m.addVar(lb=0, name="bowls_of_cereal")
ravioli = m.addVar(lb=0, name="ravioli")

# Set objective function
m.setObjective(
    1 * peanutbutter_sandwiches**2
    + 3 * peanutbutter_sandwiches * pickles
    + 3 * peanutbutter_sandwiches * bowls_of_cereal
    + 1 * peanutbutter_sandwiches * ravioli
    + 9 * pickles**2
    + 8 * bowls_of_cereal * ravioli
    + 4 * ravioli**2
    + 8 * peanutbutter_sandwiches
    + 6 * bowls_of_cereal
    + 5 * ravioli,
    gp.GRB.MAXIMIZE,
)

# Add constraints
m.addConstr(0.63 * pickles + 0.71 * ravioli >= 26, "c1")
m.addConstr(
    0.91**2 * peanutbutter_sandwiches**2 + 1.79**2 * bowls_of_cereal**2 <= 112, "c2"
)
m.addConstr(0.63 * pickles + 1.79 * bowls_of_cereal <= 63, "c3")
m.addConstr(0.63 * pickles + 0.71 * ravioli <= 69, "c4")
m.addConstr(0.63 * pickles + 1.79 * bowls_of_cereal + 0.71 * ravioli <= 138, "c5")
m.addConstr(
    0.91 * peanutbutter_sandwiches + 0.63 * pickles + 0.71 * ravioli <= 126, "c6"
)
m.addConstr(
    0.91 * peanutbutter_sandwiches + 0.63 * pickles + 1.79 * bowls_of_cereal <= 44, "c7"
)
m.addConstr(
    0.91 * peanutbutter_sandwiches
    + 0.63 * pickles
    + 1.79 * bowls_of_cereal
    + 0.71 * ravioli
    <= 44,
    "c8",
)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peanutbutter Sandwiches: {peanutbutter_sandwiches.x}")
    print(f"Pickles: {pickles.x}")
    print(f"Bowls of Cereal: {bowls_of_cereal.x}")
    print(f"Ravioli: {ravioli.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

