
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='peanutbutter sandwiches', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = m.addVar(name='pickles', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name='bowls of cereal', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name='ravioli', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(1*x0**2 + 3*x0*x1 + 3*x0*x2 + 1*x0*x3 + 9*x1**2 + 8*x2*x3 + 4*x3**2 + 8*x0 + 6*x2 + 5*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(0.91*x0 + 0.63*x1 + 1.79*x2 + 0.71*x3 <= 162, name='total carbohydrates')
m.addConstr(0.63*x1 + 0.71*x3 >= 26, name='carbohydrates from pickles and ravioli')
m.addConstr(0.91**2*x0**2 + 1.79**2*x2**2 <= 112, name='carbohydrates from peanutbutter sandwiches squared and bowls of cereal squared')
m.addConstr(0.63*x1 + 1.79*x2 <= 63, name='carbohydrates from pickles and bowls of cereal')
m.addConstr(0.63*x1 + 0.71*x3 <= 69, name='carbohydrates from pickles and ravioli')
m.addConstr(0.63*x1 + 1.79*x2 + 0.71*x3 <= 138, name='carbohydrates from pickles, bowls of cereal, and ravioli')
m.addConstr(0.91*x0 + 0.63*x1 + 0.71*x3 <= 126, name='carbohydrates from peanutbutter sandwiches, pickles, and ravioli')
m.addConstr(0.91*x0 + 0.63*x1 + 1.79*x2 <= 44, name='carbohydrates from peanutbutter sandwiches, pickles, and bowls of cereal')
m.addConstr(0.91*x0 + 0.63*x1 + 1.79*x2 + 0.71*x3 <= 44, name='carbohydrates from all sources')

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Peanutbutter sandwiches: ', x0.varValue)
    print('Pickles: ', x1.varValue)
    print('Bowls of cereal: ', x2.varValue)
    print('Ravioli: ', x3.varValue)
else:
    print('The model is infeasible')
