
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkOptimization")

# Create variables
paul = model.addVar(vtype=GRB.INTEGER, name="Paul")
bill = model.addVar(vtype=GRB.INTEGER, name="Bill")
hank = model.addVar(vtype=GRB.INTEGER, name="Hank")
george = model.addVar(vtype=GRB.INTEGER, name="George")
mary = model.addVar(vtype=GRB.INTEGER, name="Mary")

# Set objective function
model.setObjective(1.59*paul*paul + 2.71*paul*bill + 8.71*paul*hank + 4.76*paul*george + 8.46*bill*hank + 9.89*bill*mary + 5.54*hank*hank + 2.64*hank*george + 9.0*hank*mary + 6.86*george*mary + 4.5*hank + 2.12*george + 5.37*mary, GRB.MINIMIZE)

# Add constraints
model.addConstr(14*bill*bill + 5*george*george >= 17)
model.addConstr(5*george + 9*mary >= 17)
model.addConstr(14*paul + 16*hank >= 16)
model.addConstr(15*bill + 16*hank >= 27)
model.addConstr(14*paul*paul + 9*mary*mary >= 32)
model.addConstr(16*hank + 5*george >= 15)
model.addConstr(15*bill + 9*mary >= 36)
model.addConstr(14*paul*paul + 5*george*george >= 38)
model.addConstr(14*paul + 15*bill + 16*hank + 5*george + 9*mary >= 38)

model.addConstr(george + 10*mary >= 23)
model.addConstr(11*hank*hank + 10*mary*mary >= 36)
model.addConstr(4*bill + 10*mary >= 39)
model.addConstr(4*paul + george >= 14)
model.addConstr(4*bill + 11*hank >= 28)
model.addConstr(11*hank + george >= 31)
model.addConstr(4*bill + 11*hank + 10*mary >= 38)
model.addConstr(4*paul + 4*bill + george >= 38)
model.addConstr(11*hank + george + 10*mary >= 38)
model.addConstr(4*bill*bill + 11*hank*hank + 10*mary*mary >= 27)
model.addConstr(4*paul*paul + 4*bill*bill + george*george >= 27)
model.addConstr(11*hank*hank + george*george + 10*mary*mary >= 27)
model.addConstr(4*bill + 11*hank + 10*mary >= 37)
model.addConstr(4*paul*paul + 4*bill*bill + george*george >= 37)
model.addConstr(11*hank + george + 10*mary >= 37)
model.addConstr(4*paul + 4*bill + 11*hank + george + 10*mary >= 37)


model.addConstr(-5*paul*paul + hank*hank + 8*mary*mary >= 0)
model.addConstr(16*hank + 5*george <= 135)
model.addConstr(5*george*george + 9*mary*mary <= 52)
model.addConstr(16*hank + 9*mary <= 108)
model.addConstr(14*paul + 15*bill <= 129)
model.addConstr(15*bill*bill + 5*george*george <= 63)
model.addConstr(14*paul + 16*hank <= 165)
model.addConstr(15*bill + 16*hank <= 180)
model.addConstr(16*hank*hank + 5*george*george + 9*mary*mary <= 154)

model.addConstr(4*bill + 10*mary <= 63)
model.addConstr(4*paul + 4*bill <= 186)
model.addConstr(4*bill + george <= 182)
model.addConstr(4*bill + 11*hank <= 97)
model.addConstr(4*paul + 10*mary <= 41)
model.addConstr(4*paul + 11*hank <= 86)
model.addConstr(4*paul*paul + george*george <= 189)
model.addConstr(4*paul + 4*bill + 11*hank <= 160)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Optimization ended with status %d" % model.status)

