
import gurobi as gp
from gurobi import GRB

# Define the model
model = gp.Model("optimization_problem")

# Define the variables
x0 = model.addVar(name="hours_worked_by_Paul", vtype=GRB.INTEGER)
x1 = model.addVar(name="hours_worked_by_Bill", vtype=GRB.INTEGER)
x2 = model.addVar(name="hours_worked_by_Hank", vtype=GRB.INTEGER)
x3 = model.addVar(name="hours_worked_by_George", vtype=GRB.INTEGER)
x4 = model.addVar(name="hours_worked_by_Mary", vtype=GRB.INTEGER)

# Define the objective function
model.setObjective(1.59*x0**2 + 2.71*x0*x1 + 8.71*x0*x2 + 4.76*x0*x3 + 8.46*x1*x2 + 9.89*x1*x4 + 5.54*x2**2 + 2.64*x2*x3 + 9.0*x2*x4 + 6.86*x3*x4 + 4.5*x2 + 2.12*x3 + 5.37*x4, GRB.MINIMIZE)

# Individual work quality ratings
model.addConstr(x0 == 14, name="Paul_work_quality")
model.addConstr(x1 == 15, name="Bill_work_quality")
model.addConstr(x2 == 16, name="Hank_work_quality")
model.addConstr(x3 == 5, name="George_work_quality")
model.addConstr(x4 == 9, name="Mary_work_quality")

# Individual likelihood to quit indices
model.addConstr(x0 == 4, name="Paul_likelihood_to_quit")
model.addConstr(x1 == 4, name="Bill_likelihood_to_quit")
model.addConstr(x2 == 11, name="Hank_likelihood_to_quit")
model.addConstr(x3 == 1, name="George_likelihood_to_quit")
model.addConstr(x4 == 10, name="Mary_likelihood_to_quit")

# Combined work quality ratings constraints
model.addConstr(x1**2 + x3**2 >= 17, name="combined_work_quality_1")
model.addConstr(x3 + x4 >= 17, name="combined_work_quality_2")
model.addConstr(x0 + x2 >= 16, name="combined_work_quality_3")
model.addConstr(x1 + x2 >= 27, name="combined_work_quality_4")
model.addConstr(x0**2 + x4**2 >= 32, name="combined_work_quality_5")
model.addConstr(x2 + x3 >= 15, name="combined_work_quality_6")
model.addConstr(x1 + x4 >= 36, name="combined_work_quality_7")
model.addConstr(x0**2 + x3**2 >= 38, name="combined_work_quality_8")
model.addConstr(x0 + x1 + x2 + x3 + x4 >= 38, name="combined_work_quality_9")
model.addConstr(x2 + x3 + x4 <= 108, name="combined_work_quality_10")
model.addConstr(x0 + x1 <= 129, name="combined_work_quality_11")
model.addConstr(x1**2 + x3**2 <= 63, name="combined_work_quality_12")
model.addConstr(x0 + x2 <= 165, name="combined_work_quality_13")
model.addConstr(x1 + x2 <= 180, name="combined_work_quality_14")
model.addConstr(x2**2 + x3**2 + x4**2 <= 154, name="combined_work_quality_15")

# Combined likelihood to quit indices constraints
model.addConstr(x3 + x4 >= 23, name="combined_likelihood_to_quit_1")
model.addConstr(x2**2 + x4**2 >= 36, name="combined_likelihood_to_quit_2")
model.addConstr(x1 + x4 >= 39, name="combined_likelihood_to_quit_3")
model.addConstr(x0 + x3 >= 14, name="combined_likelihood_to_quit_4")
model.addConstr(x1 + x2 >= 28, name="combined_likelihood_to_quit_5")
model.addConstr(x2 + x3 >= 31, name="combined_likelihood_to_quit_6")
model.addConstr(x1 + x2 + x4 >= 38, name="combined_likelihood_to_quit_7")
model.addConstr(x0 + x1 + x3 >= 38, name="combined_likelihood_to_quit_8")
model.addConstr(x2 + x3 + x4 >= 38, name="combined_likelihood_to_quit_9")
model.addConstr(x1**2 + x2**2 + x4**2 >= 27, name="combined_likelihood_to_quit_10")
model.addConstr(x0**2 + x1**2 + x3**2 >= 27, name="combined_likelihood_to_quit_11")
model.addConstr(x2**2 + x3**2 + x4**2 >= 27, name="combined_likelihood_to_quit_12")
model.addConstr(x1 + x2 + x4 >= 37, name="combined_likelihood_to_quit_13")
model.addConstr(x0**2 + x1**2 + x3**2 >= 37, name="combined_likelihood_to_quit_14")
model.addConstr(x2 + x3 + x4 >= 37, name="combined_likelihood_to_quit_15")
model.addConstr(x0 + x1 + x2 + x3 + x4 >= 37, name="combined_likelihood_to_quit_16")

model.addConstr(-5*x0**2 + x2**2 + 8*x4**2 >= 0, name="quadratic_constraint")

model.addConstr(x2 + x3 <= 135, name="work_quality_constraint_1")
model.addConstr(x3**2 + x4**2 <= 52, name="work_quality_constraint_2")
model.addConstr(x1*x4 <= 63, name="likelihood_constraint_1")
model.addConstr(x0 + x1 <= 186, name="likelihood_constraint_2")
model.addConstr(x1 + x3 <= 182, name="likelihood_constraint_3")
model.addConstr(x1 + x2 <= 97, name="likelihood_constraint_4")
model.addConstr(x0 + x4 <= 41, name="likelihood_constraint_5")
model.addConstr(x0 + x2 <= 86, name="likelihood_constraint_6")
model.addConstr(x0**2 + x3**2 <= 189, name="likelihood_constraint_7")
model.addConstr(x0 + x1 + x2 <= 160, name="likelihood_constraint_8")

# Solve the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Hours worked by Paul: ", x0.varValue)
    print("Hours worked by Bill: ", x1.varValue)
    print("Hours worked by Hank: ", x2.varValue)
    print("Hours worked by George: ", x3.varValue)
    print("Hours worked by Mary: ", x4.varValue)
else:
    print("The model is infeasible")
