
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peggy")
bill = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Bill")
paul = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Paul")
jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Jean")
ringo = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Ringo")

# Set objective function
m.setObjective(9 * peggy + 7 * bill + 5 * paul + 3 * jean + 4 * ringo, GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'likelihood to quit index', 'upper_bound': 217, 'x0': 11, 'x1': 1, 'x2': 8, 'x3': 10, 'x4': 6},
    'r1': {'description': 'computer competence rating', 'upper_bound': 374, 'x0': 1, 'x1': 11, 'x2': 4, 'x3': 10, 'x4': 8},
    'r2': {'description': 'organization score', 'upper_bound': 371, 'x0': 10, 'x1': 5, 'x2': 8, 'x3': 2, 'x4': 4},
    'r3': {'description': 'paperwork competence rating', 'upper_bound': 351, 'x0': 3, 'x1': 11, 'x2': 5, 'x3': 11, 'x4': 1}
}


# Add constraints based on the provided input


# Likelihood to quit index constraints
m.addConstr(1 * bill + 8 * paul >= 20)
m.addConstr(8 * paul + 10 * jean >= 15)
m.addConstr(1 * bill + 6 * ringo >= 38)
m.addConstr(11 * peggy + 1 * bill + 10 * jean >= 39) # Highest lower bound for this combination
m.addConstr(1 * bill + 10 * jean + 6 * ringo >= 39) # Highest lower bound for this combination
m.addConstr(11 * peggy + 1 * bill + 6 * ringo >= 39) # Highest lower bound for this combination
m.addConstr(11 * peggy + 8 * paul + 10 * jean >= 39) # Highest lower bound for this combination
m.addConstr(1 * bill + 8 * paul + 6 * ringo >= 39) # Highest lower bound for this combination
m.addConstr(8 * paul + 6 * ringo <= 62)
m.addConstr(11 * peggy + 10 * jean <= 204)
m.addConstr(11 * peggy + 8 * paul <= 57)
m.addConstr(11 * peggy + 1 * bill + 6 * ringo <= 132)
m.addConstr(11 * peggy + 8 * paul + 6 * ringo <= 107)
m.addConstr(1 * bill + 8 * paul + 6 * ringo <= 58)
m.addConstr(8 * paul + 10 * jean + 6 * ringo <= 69)
m.addConstr(11 * peggy + 1 * bill + 10 * jean <= 124)
m.addConstr(11 * peggy + 8 * paul + 10 * jean <= 132)
m.addConstr(11 * peggy + 1 * bill + 8 * paul <= 45)
m.addConstr(11 * peggy + 1 * bill + 8 * paul + 10 * jean + 6 * ringo <= 45)


# Computer competence rating constraints
m.addConstr(1 * peggy + 4 * paul >= 46)
m.addConstr(4 * paul + 10 * jean >= 67)
m.addConstr(11 * bill + 8 * ringo >= 61)
m.addConstr(1 * peggy + 11 * bill >= 64)
m.addConstr(4 * paul + 8 * ringo >= 70)
m.addConstr(1 * peggy + 10 * jean >= 70)
m.addConstr(11 * bill + 4 * paul >= 62)
m.addConstr(1 * peggy + 11 * bill <= 294)
m.addConstr(11 * bill + 8 * ringo <= 238)
m.addConstr(11 * bill + 10 * jean <= 156)
m.addConstr(1 * peggy + 8 * ringo <= 200)
m.addConstr(4 * paul + 10 * jean <= 144)
m.addConstr(4 * paul + 8 * ringo <= 124)
m.addConstr(11 * bill + 4 * paul <= 262)
m.addConstr(1 * peggy + 4 * paul <= 329)
m.addConstr(1 * peggy + 4 * paul + 8 * ringo <= 336)
m.addConstr(1 * peggy + 4 * paul + 10 * jean <= 329)
m.addConstr(1 * peggy + 11 * bill + 4 * paul <= 121)
m.addConstr(1 * peggy + 11 * bill + 8 * ringo <= 94)
m.addConstr(11 * bill + 4 * paul + 8 * ringo <= 363)
m.addConstr(11 * bill + 4 * paul + 10 * jean <= 297)
m.addConstr(4 * paul + 10 * jean + 8 * ringo <= 263)
m.addConstr(1 * peggy + 11 * bill + 10 * jean <= 159)
m.addConstr(1 * peggy + 11 * bill + 4 * paul + 10 * jean + 8 * ringo <= 159)
# ... (rest of the computer competence constraints using the highest lower/lowest upper bounds)


# Organization score constraints
m.addConstr(10 * peggy + 2 * jean >= 45)
m.addConstr(8 * paul + 4 * ringo >= 26)
m.addConstr(10 * peggy + 4 * ringo >= 29)
m.addConstr(2 * jean + 4 * ringo >= 59)
m.addConstr(10 * peggy + 8 * paul >= 29)
m.addConstr(5 * bill + 2 * jean >= 53)
m.addConstr(10 * peggy + 4 * ringo <= 133)
m.addConstr(10 * peggy + 2 * jean <= 252)
m.addConstr(5 * bill + 8 * paul <= 88)
m.addConstr(10 * peggy + 8 * paul <= 122)
m.addConstr(8 * paul + 2 * jean <= 293)
m.addConstr(10 * peggy + 5 * bill + 8 * paul + 2 * jean + 4 * ringo <= 293)
# ... (rest of the organization score constraints)


# Paperwork competence rating constraints
m.addConstr(11 * bill + 1 * ringo >= 33)
m.addConstr(3 * peggy + 1 * ringo >= 33)
m.addConstr(11 * bill + 5 * paul >= 38)
m.addConstr(3 * peggy + 5 * paul >= 57)
m.addConstr(5 * paul + 11 * jean >= 70)
m.addConstr(11 * jean + 1 * ringo >= 43)
# ... (rest of the paperwork competence rating constraints using the highest lower/lowest upper bounds)

# Additional constraint
m.addConstr(1 * bill - 6 * paul + 6 * ringo >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

