
from gurobipy import Model, GRB

# Create a new model
m = Model("military_optimization")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="mechanized infantry companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="medical platoons")

# Set objective function
m.setObjective(9*x0*x0 + 6*x0*x1 + 2*x1*x1 + x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x0*x0 + x1*x1 >= 22, "c0")  # offensive capability rating (squared)
m.addConstr(18*x0 + 15*x1 >= 40, "c1")  # logistical capacity
m.addConstr(14*x0 + 9*x1 >= 26, "c2")  # fun factor
m.addConstr(17*x0*x0 + 11*x1*x1 >= 29, "c3")  # defensive capability rating (squared)
m.addConstr(-7*x0 + 6*x1 >= 0, "c4")
m.addConstr(12*x0 + x1 <= 102, "c5")  # offensive capability rating (upper bound)
m.addConstr(18*x0 + 15*x1 <= 107, "c6")  # logistical capacity (upper bound)
m.addConstr(14*x0 + 9*x1 <= 42, "c7")  # fun factor (upper bound)
m.addConstr(17*x0 + 11*x1 <= 63, "c8")  # defensive capability rating (upper bound)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('mechanized infantry companies:', x0.x)
    print('medical platoons:', x1.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

